<?php
/**
 * Health Check Configuration - Default Thresholds
 *
 * These defaults can be overridden via URL parameters:
 * ?connections_warning=500&connections_critical=800
 * ?cpu_warning=1.5&cpu_critical=2.5
 * ?disk_warning=85&disk_critical=95
 * ?swap_warning=60&swap_critical=85
 */

// Prevent direct access
if (!defined('WHP')) {
    http_response_code(403);
    die('Direct access not permitted');
}

// Default connection thresholds (based on unique client IPs)
define('HEALTH_CHECK_CONNECTIONS_WARNING_DEFAULT', 750);
define('HEALTH_CHECK_CONNECTIONS_CRITICAL_DEFAULT', 1000);

// Default CPU load thresholds (per core)
define('HEALTH_CHECK_CPU_WARNING_DEFAULT', 1.2);
define('HEALTH_CHECK_CPU_CRITICAL_DEFAULT', 2.0);

// Default disk usage thresholds (percentage)
define('HEALTH_CHECK_DISK_WARNING_DEFAULT', 80);
define('HEALTH_CHECK_DISK_CRITICAL_DEFAULT', 90);

// Default swap usage thresholds (percentage)
define('HEALTH_CHECK_SWAP_WARNING_DEFAULT', 50);
define('HEALTH_CHECK_SWAP_CRITICAL_DEFAULT', 80);

// Rate limiting settings (not overridable for security)
define('HEALTH_CHECK_RATE_LIMIT_WINDOW', 60);
define('HEALTH_CHECK_RATE_LIMIT_MAX', 10);
?>
