-- Add 'claimed' status to backup_history table for worker coordination
-- This status prevents race conditions between multiple backup workers

USE whp;

-- Add 'claimed' status to the ENUM between 'pending' and 'running'
-- This represents backups that have been claimed by a worker but not yet started processing
ALTER TABLE backup_history
MODIFY COLUMN status ENUM('pending', 'claimed', 'running', 'completed', 'failed', 'deleted') NOT NULL DEFAULT 'pending';

-- Update any backups that are stuck in 'running' status for more than 30 minutes
-- These are likely from the previous implementation and should be reset
UPDATE backup_history
SET status = 'failed',
    error_message = 'Backup stuck in running state during migration - automatically reset',
    completed_at = NOW()
WHERE status = 'running'
AND started_at < DATE_SUB(NOW(), INTERVAL 30 MINUTE);