-- Migration: Allow Multiple Forwarder Destinations
-- Date: 2025-01-05
-- Purpose: Allow multiple email_forwarders entries with same source_email but different destination_email

USE whp;

-- Drop the existing unique constraint that prevents multiple destinations
ALTER TABLE email_forwarders DROP INDEX IF EXISTS unique_forward;

-- Add a new unique constraint that allows same source with different destinations
-- This prevents duplicate source+destination pairs while allowing multiple destinations
ALTER TABLE email_forwarders ADD UNIQUE INDEX IF NOT EXISTS unique_forward (source_email, destination_email);

-- Keep the source_email index for efficient querying
-- (This likely already exists but we ensure it's there)
ALTER TABLE email_forwarders ADD INDEX IF NOT EXISTS idx_source_email (source_email);