#!/usr/bin/env bash
#
# Add SSL certificate refresh cron job for system services
#
# This script adds a daily cron job to refresh SSL certificates for system
# services (httpd, proftpd) from the HAProxy container.
#

set -euo pipefail

echo "Adding SSL certificate refresh cron job..."

# Define the cron job
CRON_JOB="0 3 * * * /usr/bin/php /root/whp/scripts/refresh-system-ssl.php >/dev/null 2>&1"
CRON_COMMENT="# WHP System Service SSL - Refresh certificates daily at 3 AM"

# Check if cron job already exists
if crontab -l 2>/dev/null | grep -q "refresh-system-ssl.php"; then
    echo "SSL refresh cron job already exists, skipping..."
    exit 0
fi

# Add the cron job
(crontab -l 2>/dev/null || echo "") | {
    cat
    echo ""
    echo "$CRON_COMMENT"
    echo "$CRON_JOB"
} | crontab -

echo "SSL certificate refresh cron job added successfully"
echo "Schedule: Daily at 3:00 AM"
echo "Command: /usr/bin/php /root/whp/scripts/refresh-system-ssl.php"

exit 0
