-- Create WordPress Update Queue Table
-- This table manages queued WordPress updates that wait for backup completion

USE whp;

CREATE TABLE IF NOT EXISTS wp_update_queue (
    id INT AUTO_INCREMENT PRIMARY KEY,
    site_id INT NOT NULL,
    update_id INT NOT NULL,
    update_type VARCHAR(20) NOT NULL COMMENT 'core, plugins, themes, all',
    backup_id INT DEFAULT NULL COMMENT 'ID of backup that must complete first',
    status ENUM('waiting_for_backup', 'ready', 'processing', 'completed', 'failed') DEFAULT 'waiting_for_backup',
    error_message TEXT DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    started_at TIMESTAMP NULL DEFAULT NULL,
    completed_at TIMESTAMP NULL DEFAULT NULL,

    INDEX idx_status (status),
    INDEX idx_backup_id (backup_id),
    INDEX idx_site_id (site_id),
    INDEX idx_created_at (created_at),

    FOREIGN KEY (site_id) REFERENCES wordpress_sites(id) ON DELETE CASCADE,
    FOREIGN KEY (update_id) REFERENCES wp_update_history(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;