-- WordPress Security Settings Enhancements
-- Date: 2025-07-21
-- Description: Add additional security settings columns to wp_security_settings table

USE whp;

-- Add new security settings columns
ALTER TABLE wp_security_settings 
ADD COLUMN IF NOT EXISTS security_headers_enabled BOOLEAN DEFAULT TRUE AFTER limit_login_attempts,
ADD COLUMN IF NOT EXISTS block_php_uploads BOOLEAN DEFAULT TRUE AFTER block_php_in_uploads,
ADD COLUMN IF NOT EXISTS force_strong_passwords BOOLEAN DEFAULT FALSE AFTER block_php_uploads;

-- Update existing rows to have sensible defaults for new columns
UPDATE wp_security_settings SET 
    security_headers_enabled = TRUE,
    block_php_uploads = TRUE,
    force_strong_passwords = FALSE
WHERE security_headers_enabled IS NULL 
   OR block_php_uploads IS NULL 
   OR force_strong_passwords IS NULL;

-- Verify the structure
SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'whp' 
  AND TABLE_NAME = 'wp_security_settings'
ORDER BY ORDINAL_POSITION;