#!/usr/bin/env bash

# Install pigz (parallel gzip) for faster backup compression
echo "Installing pigz for improved backup compression performance..."

# Check if pigz is already installed
if command -v pigz >/dev/null 2>&1; then
    echo "✓ pigz is already installed"
else
    # Install pigz based on the distribution
    if [ -f /etc/redhat-release ] || [ -f /etc/centos-release ] || [ -f /etc/rocky-release ] || [ -f /etc/almalinux-release ]; then
        # RHEL-based systems
        echo "Installing pigz on RHEL-based system..."
        dnf install -y pigz || yum install -y pigz
    elif [ -f /etc/debian_version ]; then
        # Debian-based systems
        echo "Installing pigz on Debian-based system..."
        apt-get update && apt-get install -y pigz
    else
        echo "⚠ Unknown distribution, attempting generic install..."
        dnf install -y pigz || yum install -y pigz || apt-get install -y pigz || echo "✗ Failed to install pigz"
    fi
    
    # Verify installation
    if command -v pigz >/dev/null 2>&1; then
        echo "✓ pigz installed successfully"
    else
        echo "⚠ pigz installation failed - backups will continue using standard gzip"
    fi
fi

echo ""
echo "Backup compression optimization complete."
echo "The backup system will automatically use pigz for parallel compression when available."