#!/usr/bin/env bash
# Add backup upload worker cron job to process upload queue
# This script adds the missing cron job for backup-upload-worker.php

set -euo pipefail

echo "Adding backup upload worker cron job..."

# Check if the cron job already exists
if crontab -l 2>/dev/null | grep -q "backup-upload-worker.php"; then
    echo "✓ Backup upload worker cron job already exists"
    exit 0
fi

# Add the cron job
(crontab -l 2>/dev/null; echo "# WHP Backup System - Process upload queue every 2 minutes") | crontab -
(crontab -l 2>/dev/null; echo "*/2 * * * * /usr/bin/php /docker/whp/web/scripts/backup-upload-worker.php >/dev/null 2>&1") | crontab -

echo "✓ Backup upload worker cron job added successfully"

# Manually trigger the upload worker once to process any pending uploads
if [ -f "/docker/whp/web/scripts/backup-upload-worker.php" ]; then
    echo "Triggering upload worker to process any pending uploads..."
    /usr/bin/php /docker/whp/web/scripts/backup-upload-worker.php >/dev/null 2>&1 &
    echo "✓ Upload worker triggered"
fi

exit 0