<?php
// Only run chown on the specific uploaded file to avoid unnecessary overhead
if (isset($_GET['action']) && $_GET['action'] === 'upload' && isset($_FILES['file']) && isset($_GET['dir'])) {
    // Get the uploaded filename and directory
    $filename = $_FILES['file']['name'];
    $dir = $_GET['dir'];
    
    // Handle relative path if it exists (for folder structure preservation)
    if (isset($_POST['relativePath']) && !empty($_POST['relativePath']) && $_POST['relativePath'] != 'null' && $_POST['relativePath'] != $filename && strpos($_POST['relativePath'], '/') !== false) {
        $dir = dirname("$dir/{$_POST['relativePath']}");
    }
    
    // Build the full path to the uploaded file
    $uploaded_file = rtrim($dir, '/') . '/' . $filename;
    
    // Only chown if the file exists (upload was successful)
    if (file_exists($uploaded_file)) {
        $chown_command = "/bin/chown " . AUTH_USER . ":" . AUTH_USER . " " . escapeshellarg($uploaded_file);
        $results = shell_exec($chown_command);
    }
}

