{*
 * WHP WHMCS Module - Client Area Overview Template
 *}

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fa fa-server"></i>
            Account Overview
        </h3>
    </div>
    <div class="panel-body">
        
        {if $user_info}
            <div class="row">
                <div class="col-md-6">
                    <h4>Account Information</h4>
                    <table class="table table-condensed">
                        <tr>
                            <td><strong>Username:</strong></td>
                            <td>{$user_info.username}</td>
                        </tr>
                        {if $user_info.uid}
                        <tr>
                            <td><strong>User ID:</strong></td>
                            <td>{$user_info.uid}</td>
                        </tr>
                        {/if}
                        {if $user_info.home_directory}
                        <tr>
                            <td><strong>Home Directory:</strong></td>
                            <td>{$user_info.home_directory}</td>
                        </tr>
                        {/if}
                    </table>
                </div>
                
                <div class="col-md-6">
                    <h4>Resource Limits</h4>
                    {if $user_info.resources}
                        <table class="table table-condensed">
                            <tr>
                                <td><strong>CPU Cores:</strong></td>
                                <td>{$user_info.resources.cpu_cores|default:'N/A'}</td>
                            </tr>
                            <tr>
                                <td><strong>Memory:</strong></td>
                                <td>{if $user_info.resources.memory_mb}{($user_info.resources.memory_mb/1024)|number_format:1} GB{else}N/A{/if}</td>
                            </tr>
                            <tr>
                                <td><strong>Disk Space:</strong></td>
                                <td>{if $user_info.resources.disk_mb}{($user_info.resources.disk_mb/1024)|number_format:1} GB{else}N/A{/if}</td>
                            </tr>
                            <tr>
                                <td><strong>Email Accounts:</strong></td>
                                <td>{$user_info.resources.email_accounts|default:'N/A'}</td>
                            </tr>
                            <tr>
                                <td><strong>Email Storage:</strong></td>
                                <td>{if $user_info.resources.email_storage_mb}{($user_info.resources.email_storage_mb/1024)|number_format:1} GB{else}N/A{/if}</td>
                            </tr>
                        </table>
                    {else}
                        <p class="text-muted">Resource information not available</p>
                    {/if}
                </div>
            </div>
            
            {if $user_info.usage}
            <div class="row">
                <div class="col-md-12">
                    <h4>Current Usage</h4>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="panel panel-info">
                                <div class="panel-body text-center">
                                    <h3>{$user_info.usage.disk_used_mb|default:'0'} MB</h3>
                                    <p>Disk Space Used</p>
                                    {if $user_info.resources.disk_mb}
                                        {assign var="disk_limit_mb" value=$user_info.resources.disk_mb}
                                        {assign var="disk_used_mb" value=$user_info.usage.disk_used_mb|default:0}
                                        {assign var="disk_percent" value=($disk_used_mb/$disk_limit_mb)*100}
                                        <div class="progress">
                                            <div class="progress-bar {if $disk_percent > 80}progress-bar-danger{elseif $disk_percent > 60}progress-bar-warning{else}progress-bar-success{/if}" 
                                                 role="progressbar" style="width: {$disk_percent|number_format:1}%">
                                                {$disk_percent|number_format:1}%
                                            </div>
                                        </div>
                                        <small class="text-muted">of {($disk_limit_mb/1024)|number_format:1} GB limit</small>
                                    {/if}
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="panel panel-info">
                                <div class="panel-body text-center">
                                    <h3>{$user_info.usage.email_storage_used_mb|default:'0'} MB</h3>
                                    <p>Email Storage Used</p>
                                    {if $user_info.resources.email_storage_mb}
                                        {assign var="email_limit_mb" value=$user_info.resources.email_storage_mb}
                                        {assign var="email_used_mb" value=$user_info.usage.email_storage_used_mb|default:0}
                                        {assign var="email_percent" value=($email_used_mb/$email_limit_mb)*100}
                                        <div class="progress">
                                            <div class="progress-bar {if $email_percent > 80}progress-bar-danger{elseif $email_percent > 60}progress-bar-warning{else}progress-bar-success{/if}" 
                                                 role="progressbar" style="width: {$email_percent|number_format:1}%">
                                                {$email_percent|number_format:1}%
                                            </div>
                                        </div>
                                        <small class="text-muted">of {($email_limit_mb/1024)|number_format:1} GB limit</small>
                                    {else}
                                        <small class="text-muted">Email storage limit not configured</small>
                                    {/if}
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    {if $user_info.usage.last_updated}
                    <p class="text-muted text-right">
                        <small>Last updated: {$user_info.usage.last_updated}</small>
                    </p>
                    {/if}
                </div>
            </div>
            {/if}
            
            <div class="row">
                <div class="col-md-12">
                    <h4>Quick Actions</h4>
                    <div class="btn-group" role="group">
                        <a href="javascript:void(0);" onclick="openControlPanel();" 
                           class="btn btn-primary">
                            <i class="fa fa-sign-in"></i> Access Control Panel
                        </a>
                    </div>
                </div>
            </div>
            
        {else}
            <div class="alert alert-warning">
                <i class="fa fa-exclamation-triangle"></i>
                Unable to retrieve account information at this time. Please try again later.
            </div>
        {/if}
        
    </div>
</div>

{* Server statistics removed - clients should only see their own resource usage *}


<style>
.progress {
    height: 6px;
    margin-bottom: 5px;
}

.panel .table {
    margin-bottom: 0;
}

.btn-group {
    margin-bottom: 15px;
}

.modal-dialog {
    margin-top: 100px;
}
</style>

<script>
function openControlPanel() {
    // Show loading message
    var loadingBtn = '<i class="fa fa-spinner fa-spin"></i> Generating login link...';
    var originalBtn = $('a[onclick="openControlPanel();"]').html();
    $('a[onclick="openControlPanel();"]').html(loadingBtn).prop('disabled', true);
    
    // Make AJAX request to get SSO URL
    $.ajax({
        url: '{$SYSTEMURL}modules/servers/whp/sso.php',
        method: 'POST',
        data: {
            serviceid: '{$serviceid}',
            username: '{$username}'
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                // Open the control panel in a new window
                window.open(response.url, '_blank', 'width=1200,height=800,scrollbars=yes,resizable=yes');
            } else {
                alert('Error: ' + (response.message || 'Unable to generate login link'));
            }
        },
        error: function() {
            alert('Error: Unable to connect to server');
        },
        complete: function() {
            // Restore button
            $('a[onclick="openControlPanel();"]').html(originalBtn).prop('disabled', false);
        }
    });
}
</script>