#!/usr/bin/env php
<?php

require_once(__DIR__ . '/../web-files/configs/config.php');
require_once(__DIR__ . '/../web-files/libs/mysqlmgmt.php');

try {
    $mysql = new mysqlmgmt();
    $db = $mysql->getMySQLConnection();
    $db->exec("USE whp");
    
    echo "WordPress sites:\n";
    echo str_repeat("-", 80) . "\n";
    
    $stmt = $db->query("SELECT * FROM wordpress_sites");
    $sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($sites)) {
        echo "No WordPress sites found.\n";
    } else {
        foreach ($sites as $site) {
            echo sprintf(
                "ID: %d | Domain: %s | User: %s | Container: %s | DB: %s | Created: %s\n",
                $site['id'],
                $site['domain'],
                $site['user'],
                $site['container_name'],
                $site['database_name'],
                $site['created_at']
            );
        }
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}