<?php
require("/docker/whp/web/libs/security.php");
require('/docker/whp/web/configs/config.php');
require('/docker/whp/web/libs/network.php');
require('/docker/whp/web/libs/security_manager.php');
require('/docker/whp/web/libs/permission_checker.php');
require('/docker/whp/web/libs/delegated_user_manager.php');

// Function to check if current request is to an API endpoint
function is_api_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = $_SERVER['REQUEST_URI'];

    // Check if the script is in the API directory
    if (strpos($script_path, '/docker/whp/web/api/') !== false) {
        return true;
    }

    // Check if the request URI starts with /api/
    if (strpos($request_uri, '/api/') === 0) {
        return true;
    }

    return false;
}

// Function to check if current request is to the health check endpoint (no auth required)
function is_health_check_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = $_SERVER['REQUEST_URI'];

    // Check if the script is health.php
    if (strpos($script_path, '/api/health.php') !== false) {
        return true;
    }

    // Check if the request URI is for health check
    if (strpos($request_uri, '/api/health.php') !== false) {
        return true;
    }

    return false;
}

// Function to check if current request is to Adminer
function is_adminer_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = $_SERVER['REQUEST_URI'];
    $script_name = basename($_SERVER['SCRIPT_NAME']);
    
    // Check if the script is adminer.php
    if ($script_name === 'adminer.php') {
        return true;
    }
    
    // Check if the request URI is for adminer
    if (strpos($request_uri, '/adminer.php') !== false) {
        return true;
    }
    
    // Check if the script path contains adminer.php
    if (strpos($script_path, 'adminer.php') !== false) {
        return true;
    }
    
    return false;
}

// Function to check if current request is to filemanager
function is_filemanager_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    
    // Check if the script is in the filemanager directory
    if (strpos($script_path, '/docker/whp/web/filemanager/') === 0) {
        return true;
    }
    
    // Check if the request URI starts with /filemanager/ (exact match)
    if (strpos($request_uri, '/filemanager/') === 0) {
        return true;
    }
    
    return false;
}

// Function to validate CSRF token
function validate_csrf_token() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $csrf_token = null;
        
        // Check for CSRF token in POST data first
        if (!empty($_POST['csrf_token'])) {
            $csrf_token = $_POST['csrf_token'];
        }
        // For API endpoints, check X-CSRF-Token header
        elseif (!empty($_SERVER['HTTP_X_CSRF_TOKEN'])) {
            $csrf_token = $_SERVER['HTTP_X_CSRF_TOKEN'];
        }
        
        if (empty($_SESSION['csrf_token']) || empty($csrf_token)) {
            return false;
        }
        
        // Use hash_equals to prevent timing attacks
        return hash_equals($_SESSION['csrf_token'], $csrf_token);
    }
    return true; // GET requests don't need CSRF validation
}

// Function to get CSRF token for forms
function get_csrf_token() {
    return isset($_SESSION['csrf_token']) ? $_SESSION['csrf_token'] : '';
}

// Skip all authentication and security checks for health check endpoint
if (is_health_check_endpoint()) {
    // Health check endpoint requires no authentication
    return;
}

$SecMan = new security_wrapper();
$NetInfo = new network_info();
$SecManager = new security_manager();
$client_ip = $NetInfo->get_client_ip();
// Clean up expired blocks
$SecManager->cleanup_expired_blocks();

// Check if IP is blocked
$blocked_info = $SecManager->is_ip_blocked($client_ip);

if ($blocked_info) {
    // IP is blocked, show block page
    if ($_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/blocked.php') {
        header('Location: /blocked.php');
        exit();
    }
}
if ( isset($_POST["user"]) && isset($_POST["password"]) ) {
    $results = $SecMan->pam_login($_POST["user"], $_POST["password"]);
    if ( $results == TRUE ) {
        // Successful PAM login - regenerate session ID to prevent session fixation
        session_regenerate_id(true);
        
        define('AUTH_USER',$_POST["user"]);
        define('HOME_DIR', $SecMan->get_home_dir($_POST["user"]));
        $_SESSION['user'] = $_POST["user"];
        $_SESSION['user_type'] = 'system';
        
        $user_ip = $NetInfo->get_client_ip();
        $nonce = $SecMan->create_nonce($_POST['user'], $user_ip,NONCE_SALT);
        $_SESSION['nonce'] = $nonce;
        
        // Generate CSRF token for this session
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        
        // Record successful login and clear failed attempts
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        $SecManager->record_successful_login($user_ip, $_POST["user"], $user_agent);
        
        // Redirect to index page
        header('Location: /index.php');
        exit();
    } else {
        // PAM login failed, try delegated user authentication
        $delegatedUserManager = new DelegatedUserManager();
        $user_ip = $NetInfo->get_client_ip();
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        
        $delegated_result = $delegatedUserManager->authenticateDelegatedUser(
            $_POST["user"], 
            $_POST["password"], 
            $user_ip, 
            $user_agent
        );
        
        if ($delegated_result['success']) {
            // Successful delegated user login
            session_regenerate_id(true);
            
            // For delegated users, AUTH_USER should be the parent user for resource access
            // but we track the actual delegated user separately
            define('AUTH_USER', $delegated_result['user']['parent_username']);
            $_SESSION['user'] = $delegated_result['user']['parent_username'];
            $_SESSION['user_type'] = 'delegated';
            $_SESSION['delegated_user'] = $delegated_result['user']['username'];
            $_SESSION['parent_user'] = $delegated_result['user']['parent_username'];
            $_SESSION['delegated_session_id'] = $delegated_result['session_id'];
            $_SESSION['delegated_user_id'] = $delegated_result['user']['id'];
            
            // For delegated users, set HOME_DIR to parent's home
            define('HOME_DIR', $SecMan->get_home_dir($delegated_result['user']['parent_username']));
            
            // Create a nonce for session management (using parent username for consistency)
            $nonce = $SecMan->create_nonce($delegated_result['user']['parent_username'], $user_ip, NONCE_SALT);
            $_SESSION['nonce'] = $nonce;
            
            // Generate CSRF token for this session
            if (empty($_SESSION['csrf_token'])) {
                $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
            }
            
            // Redirect to index page
            header('Location: /index.php');
            exit();
        } else {
            // Both PAM and delegated login failed
            $SecManager->record_failed_login($user_ip, $_POST["user"], $user_agent);
            
            // Set error message and redirect back to login
            $_SESSION['login_error'] = 'Invalid username or password.';
            header('Location: /login.php');
            exit();
        }
    }
}elseif ( isset($_SESSION['nonce'])) {
    //Test login details before getting Nonce configured
    $nonce_check = $SecMan->check_nonce($_SESSION['nonce'],$NetInfo->get_client_ip());
    if ( $nonce_check == FALSE ) {
        unset($_SESSION['nonce']);
        if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && 
             $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/blocked.php' && 
             !is_api_endpoint()) {
            if ( empty($_SERVER['HTTPS'] ) ) {
                $protocol = "http://";
                $port = "8080";
            } else {
                $protocol = "https://";
                $port = "8443";
            }
            $domain = $_SERVER['SERVER_NAME'];
            $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
            header('Location: ' . $redirect_address );
        }
    }elseif (is_array($nonce_check) ) {
        // Check if this is a delegated user session
        if (isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'delegated') {
            // Validate delegated user session
            if (isset($_SESSION['delegated_session_id'])) {
                $delegatedUserManager = new DelegatedUserManager();
                $delegated_user = $delegatedUserManager->getUserBySession($_SESSION['delegated_session_id']);
                
                if ($delegated_user) {
                    // For delegated users, AUTH_USER should be the parent user for resource access
                    define('AUTH_USER', $delegated_user['parent_username']);
                    $_SESSION['user'] = $delegated_user['parent_username'];
                    $_SESSION['delegated_user'] = $delegated_user['username'];
                    $_SESSION['parent_user'] = $delegated_user['parent_username'];
                    $_SESSION['delegated_user_id'] = $delegated_user['id'];
                    $_SESSION['delegated_display_name'] = $delegated_user['display_name'] ?? '';
                    
                    // Store delegated user permissions in session for menu filtering
                    $_SESSION['delegated_permissions'] = [
                        'can_manage_domains' => $delegated_user['can_manage_domains'],
                        'can_manage_sites' => $delegated_user['can_manage_sites'],
                        'can_manage_databases' => $delegated_user['can_manage_databases'],
                        'can_manage_email' => $delegated_user['can_manage_email'],
                        'can_manage_files' => $delegated_user['can_manage_files'],
                        'can_manage_backups' => $delegated_user['can_manage_backups'],
                        'can_view_terminal' => $delegated_user['can_view_terminal'],
                        'can_manage_wordpress' => $delegated_user['can_manage_wordpress']
                    ];
                    
                    define('HOME_DIR', $SecMan->get_home_dir($delegated_user['parent_username']));
                } else {
                    // Delegated session expired or invalid, redirect to login
                    unset($_SESSION['nonce']);
                    unset($_SESSION['user_type']);
                    unset($_SESSION['delegated_session_id']);
                    header('Location: /login.php');
                    exit();
                }
            } else {
                // No delegated session ID, redirect to login
                unset($_SESSION['nonce']);
                unset($_SESSION['user_type']);
                header('Location: /login.php');
                exit();
            }
        } else {
            // Regular system user
            define('AUTH_USER',$nonce_check['user']);
            define('HOME_DIR',$SecMan->get_home_dir($nonce_check['user']));
            $_SESSION['user'] = $nonce_check['user'];
            $_SESSION['user_type'] = 'system';
        }
        
        $user_ip = $NetInfo->get_client_ip();
        $nonce = $SecMan->create_nonce($nonce_check['user'], $user_ip,NONCE_SALT);
        $_SESSION['nonce'] = $nonce;
        
        // Generate CSRF token for this session if not already set
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
    } else {
        error_log("Invalid nonce check result: " . print_r($nonce_check, true));
        // Redirect to login for security
        header('Location: /login.php');
        exit();
    }
}else {
    // Don't require authentication for login.php, blocked.php, or API endpoints
    if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && 
         $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/blocked.php' && 
         !is_api_endpoint()) {
        if ( empty($_SERVER['HTTPS'] ) ) {
            $protocol = "http://";
            $port = "8080";
        } else {
            $protocol = "https://";
            $port = "8443";
        }
        $domain = $_SERVER['SERVER_NAME'];
        $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
        header('Location: ' . $redirect_address );
    }
}

if ( isset($_REQUEST['whp-action']) && $_REQUEST['whp-action'] == 'logout') {
    unset($_SESSION['nonce']);
    if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
        if ( empty($_SERVER['HTTPS'] ) ) {
            $protocol = "http://";
            $port = "8080";
        } else {
            $protocol = "https://";
            $port = "8443";
        }
        $domain = $_SERVER['SERVER_NAME'];
        $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
        header('Location: ' . $redirect_address );
    }
}

// Check page permissions for authenticated users
if (defined('AUTH_USER') && $_SERVER['SCRIPT_FILENAME'] == '/docker/whp/web/index.php') {
    check_page_permission();
}

// CSRF Protection for all POST requests (except login, Adminer, and filemanager)
if (defined('AUTH_USER') && $_SERVER['REQUEST_METHOD'] === 'POST') {
    // Skip CSRF check for login form, Adminer, and filemanager
    if (!isset($_POST['user']) && !isset($_POST['password']) && !is_adminer_endpoint() && !is_filemanager_endpoint()) {
        if (!validate_csrf_token()) {
            if (is_api_endpoint()) {
                header('HTTP/1.1 403 Forbidden');
                header('Content-Type: application/json');
                echo json_encode(['status' => 'error', 'message' => 'CSRF token validation failed']);
                exit;
            } else {
                header('HTTP/1.1 403 Forbidden');
                die('CSRF token validation failed. Please try again.');
            }
        }
    }
}