-- Migration script to add email storage quota to existing WHP installations
-- Run this script to add the max_email_storage_mb column to client_allowances table

USE whp;

-- Add the max_email_storage_mb column if it doesn't exist
ALTER TABLE client_allowances 
ADD COLUMN IF NOT EXISTS max_email_storage_mb INT DEFAULT 1000 
AFTER max_email_accounts;

-- Update existing records to have the default value
UPDATE client_allowances 
SET max_email_storage_mb = 1000 
WHERE max_email_storage_mb IS NULL;

-- Display the updated table structure
DESCRIBE client_allowances; 