<?php
// Toggle font size preference in session
session_start();

// Check if this is an AJAX request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Get the current state or toggle it
$largeFonts = $_SESSION['large_fonts'] ?? false;
$action = $_POST['action'] ?? 'toggle';

if ($action === 'toggle') {
    $_SESSION['large_fonts'] = !$largeFonts;
} elseif ($action === 'set') {
    $_SESSION['large_fonts'] = (bool)($_POST['value'] ?? false);
}

// Return the new state
echo json_encode([
    'success' => true,
    'large_fonts' => $_SESSION['large_fonts']
]);