-- Fix backup_type column inconsistencies across backup tables
-- This migration ensures all backup tables have consistent ENUM definitions
-- This version includes the USE database statement that was missing from the previous migration

USE whp;

-- Fix backup_history table to include 'wordpress' type that was being used by the system
ALTER TABLE backup_history 
MODIFY COLUMN backup_type ENUM('site', 'userfiles', 'database', 'wordpress', 'all') NOT NULL;

-- Fix backup_schedules table to have consistent ENUM with backup_history
ALTER TABLE backup_schedules
MODIFY COLUMN backup_type ENUM('site', 'userfiles', 'database', 'wordpress', 'all') NOT NULL 
COMMENT 'Backup type - site type auto-detects WordPress sites for combined backup';

-- Fix backup_queue table to match other tables
ALTER TABLE backup_queue
MODIFY COLUMN backup_type ENUM('site', 'userfiles', 'database', 'wordpress', 'all') NOT NULL;