#!/usr/bin/env php
<?php
// Test WordPress backup queueing

require_once(__DIR__ . '/../web-files/libs/WordPressManager.php');
require_once(__DIR__ . '/../web-files/configs/config.php');

use WHP\WordPressManager;

try {
    echo "Testing WordPress backup for site ID 1...\n";
    
    $wpManager = new WordPressManager();
    
    // Get site info
    $mysql = new mysqlmgmt();
    $db = $mysql->getMySQLConnection();
    $db->exec("USE whp");
    
    $stmt = $db->prepare("SELECT * FROM wordpress_sites WHERE id = 1");
    $stmt->execute();
    $site = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$site) {
        die("Site not found\n");
    }
    
    echo "Site found: " . $site['domain'] . "\n";
    echo "Container: " . $site['container_name'] . "\n";
    echo "User: " . $site['user'] . "\n";
    
    // Test getting database name
    $method = new ReflectionMethod($wpManager, 'getWordPressDatabaseName');
    $method->setAccessible(true);
    $dbName = $method->invoke($wpManager, $site['container_name'], $site['user']);
    
    echo "Database name: " . ($dbName ?: "FAILED TO GET") . "\n";
    
    // Test creating backup
    $method = new ReflectionMethod($wpManager, 'createBackup');
    $method->setAccessible(true);
    
    echo "Attempting to create backup...\n";
    $result = $method->invoke($wpManager, $site, 'test');
    
    print_r($result);
    
    // Check queue
    $stmt = $db->query("SELECT * FROM backup_queue WHERE created_at >= NOW() - INTERVAL 1 MINUTE");
    $queued = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\nQueued backups:\n";
    foreach ($queued as $q) {
        echo "- " . $q['backup_type'] . ": " . $q['backup_name'] . " (status: " . $q['status'] . ")\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
}