-- Terminal Access Feature
-- Adds terminal access logging and user preferences for container terminal access

USE whp;

-- Create table to log terminal access
CREATE TABLE IF NOT EXISTS terminal_access_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(255) NOT NULL,
    container_id VARCHAR(255) NOT NULL,
    container_user VARCHAR(255) NOT NULL,
    shell VARCHAR(50) NOT NULL DEFAULT 'bash',
    connected_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    disconnected_at TIMESTAMP NULL,
    commands_executed INT DEFAULT 0,
    INDEX idx_username (username),
    INDEX idx_container (container_id),
    INDEX idx_connected (connected_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Create table for user terminal preferences
CREATE TABLE IF NOT EXISTS terminal_preferences (
    username VARCHAR(255) PRIMARY KEY,
    default_shell VARCHAR(50) DEFAULT 'bash',
    theme VARCHAR(50) DEFAULT 'dark',
    font_size INT DEFAULT 14,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;