#!/usr/bin/env php
<?php

require_once(__DIR__ . '/../web-files/configs/config.php');
require_once(__DIR__ . '/../web-files/libs/mysqlmgmt.php');
require_once(__DIR__ . '/../web-files/libs/WordPressManager.php');

use WHP\WordPressManager;

try {
    $wpManager = new WordPressManager();
    
    // Test getting database name for test.com site
    $method = new ReflectionMethod($wpManager, 'getWordPressDatabaseName');
    $method->setAccessible(true);
    $dbName = $method->invoke($wpManager, 'test.com-01', 'shadowdao');
    
    echo "Database name for test.com-01 (shadowdao): " . ($dbName ?: "FAILED TO GET") . "\n";
    
    if ($dbName) {
        echo "Database name retrieval successful!\n";
        
        // Now let's update the WordPress site record with the correct database name
        $mysql = new mysqlmgmt();
        $db = $mysql->getMySQLConnection();
        $db->exec("USE whp");
        
        $stmt = $db->prepare("UPDATE wordpress_sites SET database_name = ? WHERE id = 1");
        $result = $stmt->execute([$dbName]);
        
        if ($result) {
            echo "Successfully updated WordPress site record with database name: $dbName\n";
        } else {
            echo "Failed to update WordPress site record\n";
        }
    } else {
        echo "Cannot retrieve database name - checking wp-config.php...\n";
        
        // Let's try to read wp-config.php directly
        $result = shell_exec('docker exec --user shadowdao test.com-01 cat /home/shadowdao/public_html/wp-config.php 2>/dev/null | grep DB_NAME');
        echo "wp-config.php DB_NAME line: " . ($result ?: "NOT FOUND") . "\n";
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
}