#!/bin/bash

# Example: Enhanced Update System with Post-Update Hooks
# This could be integrated into the existing update system to handle service installations

# Future enhancement idea for WHP update system:
# Add support for post-update hooks that can install services, restart services, etc.

# Example structure for enhanced updates:
# /sql/migrations/staging/XXX_feature.sql         - Database migrations (current system)
# /scripts/update-hooks/XXX_feature.sh           - Service installation hooks (new)

# Example hook script for terminal feature:
# /scripts/update-hooks/001_terminal_feature.sh

echo "Running post-update hook: Terminal Feature Installation"

# Check if terminal feature is already installed
if systemctl list-unit-files | grep -q "whp-terminal.service"; then
    echo "✓ Terminal service already installed, skipping"
    exit 0
fi

# Install terminal feature
echo "Installing terminal feature..."

# Run the terminal installation
/root/whp/scripts/update-add-terminal.sh

echo "✓ Terminal feature installation complete"

# Usage in enhanced update system:
# 1. Apply database migrations (current)
# 2. Sync files (current) 
# 3. Run post-update hooks (new)

# Benefits:
# - Automatic service installation during updates
# - Idempotent (can run multiple times safely)
# - Proper error handling
# - Logging of installation steps

# This would require enhancing the main update system to:
# 1. Scan for hook scripts in update packages
# 2. Execute them after file sync and DB migrations
# 3. Log hook execution results
# 4. Handle hook failures gracefully