-- Fix backup_history status column default value
-- This ensures the status column always has a valid default value
-- preventing "Column 'status' cannot be null" errors

-- Modify the backup_history table to ensure status has proper default
ALTER TABLE backup_history
MODIFY COLUMN status ENUM('pending', 'running', 'completed', 'failed', 'deleted') NOT NULL DEFAULT 'pending';

-- Update any NULL status values that might exist (shouldn't be any, but just in case)
UPDATE backup_history
SET status = 'failed'
WHERE status IS NULL;

-- Add comment to document the fix
ALTER TABLE backup_history
COMMENT = 'Backup history tracking - Fixed status default value to prevent null constraint violations';