<?php
// Get User's MySQL Login
// If root or super user, login to mysql as root
if ( AUTH_USER == "root" || AUTH_USER == "whp") {
    $password = trim(MYSQL_PASS);
    $user = "root";
} else {
    // For non-root users, get their MySQL password from secure storage
    $user = AUTH_USER;
    
    // Get the user's MySQL password from our secure storage
    require_once('/docker/whp/web/libs/usermgmt.php');
    $UserMgmt = new usermgmt();
    $mysql_password = $UserMgmt->getUserMySQLPassword(AUTH_USER);
    
    if ($mysql_password) {
        $password = $mysql_password;
    } else {
        // Check if password is stored in session (from password entry form)
        session_start();
        if (isset($_SESSION['mysql_password_' . AUTH_USER])) {
            $password = $_SESSION['mysql_password_' . AUTH_USER];
            // Clear the session password for security
            unset($_SESSION['mysql_password_' . AUTH_USER]);
        } else {
            // If we can't get the password, redirect to a simple entry form
            header("Location: mysql-password-entry.php");
            exit;
        }
    }
}
?>

<html>
    <body>
        <div>Logging into phpMyAdmin...</div>
        <form id="sso_login" action="phpMyAdmin/sso.php" method="post">
            <input type="hidden" name="pma_username" id="input_username" value="<?php echo trim($user); ?>">
            <input type="hidden" name="pma_password" id="input_password" value="<?php echo trim($password); ?>">
            <input type="hidden" name="server" value="1">
        </form>
        <script type="text/javascript"> document.getElementById('sso_login').submit();</script>  
    </body>
</html>