#!/bin/bash
# Fix WHP cron jobs to prevent duplicate logging

echo "Fixing WHP cron jobs to prevent duplicate logging..."

# Save current crontab, excluding the jobs we're updating
crontab -l | grep -v -E "(wordpress-auto-update.php|cleanup-backups.php|backup-scheduler.php)" > /tmp/cron_temp

# Add back the corrected cron jobs
echo "# WHP WordPress Auto-Update System - Run updates every 6 hours" >> /tmp/cron_temp
echo "0 2,8,14,20 * * * /usr/bin/php /root/whp/scripts/wordpress-auto-update.php >/dev/null 2>&1" >> /tmp/cron_temp
echo "# WHP Backup System - Cleanup old backups daily at 2 AM" >> /tmp/cron_temp
echo "0 2 * * * /usr/bin/php /root/whp/scripts/cleanup-backups.php >/dev/null 2>&1" >> /tmp/cron_temp
echo "# WHP Backup System - Process scheduled backups every 5 minutes" >> /tmp/cron_temp
echo "*/5 * * * * /usr/bin/php /root/whp/scripts/backup-scheduler.php >/dev/null 2>&1" >> /tmp/cron_temp

# Install the updated crontab
crontab /tmp/cron_temp
rm /tmp/cron_temp

echo "✓ WHP cron jobs fixed"
echo ""
echo "Current WHP cron jobs:"
crontab -l | grep -E "(wordpress-auto-update|cleanup-backups|backup-scheduler)"