<?php
// Function to load server settings
function loadServerSettings() {
    $settings = [];
    if (file_exists('/docker/whp/settings.json')) {
        $settings = json_decode(file_get_contents('/docker/whp/settings.json'), true) ?: [];
    }
    return $settings;
}

// Load server settings
$server_settings = loadServerSettings();
$server_name = $server_settings['server_name'] ?? 'Web Hosting Panel';
$server_description = $server_settings['server_description'] ?? 'Web Hosting Panel Server';
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
        <title><?php echo htmlspecialchars($server_name); ?></title>

        <!-- Bootstrap 5 -->
        <link href="bootstrap5/css/bootstrap.min.css" rel="stylesheet">
        <link href="css/bootstrap5-whp-theme.css" type="text/css" rel="stylesheet">
        <link href="css/waves.min.css" type="text/css" rel="stylesheet"><link rel="stylesheet" href="css/nanoscroller.css">
        <!--        <link rel="stylesheet" href="css/nanoscroller.css">-->
        <link href="css/style.css" type="text/css" rel="stylesheet">
        <link href="font-awesome/css/font-awesome.min.css" rel="stylesheet">
        <link href="css/themify-icons.css" rel="stylesheet">
        <link href="css/color.css" rel="stylesheet">
        <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
          <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
          <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="account<?php echo (isset($_SESSION['large_fonts']) && $_SESSION['large_fonts']) ? ' large-fonts' : ''; ?>">
        <!-- Font Size Toggle for Login Page -->
        <div class="login-font-toggle">
            <button class="font-size-toggle<?php echo (isset($_SESSION['large_fonts']) && $_SESSION['large_fonts']) ? ' active' : ''; ?>" 
                    id="fontSizeToggle" 
                    title="Toggle larger fonts">
                <i class="fa fa-font"></i>
                <span>Aa</span>
            </button>
        </div>
        
        <div class="container">
            <div class="row">
                <div class="account-col text-center">
                    <h1><?php echo htmlspecialchars($server_name); ?></h1>
                    <p class="text-muted mb-3"><?php echo htmlspecialchars($server_description); ?></p>
                    <h3>Log into your account</h3>
                    
                    <?php if (isset($_SESSION['login_error'])): ?>
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i> <?php echo htmlspecialchars($_SESSION['login_error']); ?>
                    </div>
                    <?php 
                        unset($_SESSION['login_error']);
                    endif; ?>
                    
                    <form class="mt-4" role="form" action="index.php" method="post">
                        <div class="mb-4">
                            <label for="username" class="form-label visually-hidden">Username</label>
                            <input type="text" class="form-control form-control-lg" id="username" name="user" placeholder="Username" required>
                        </div>
                        <div class="mb-4">
                            <label for="password" class="form-label visually-hidden">Password</label>
                            <input type="password" class="form-control form-control-lg" id="password" name="password" placeholder="Password" required>
                        </div>
                        <div class="d-grid mb-4">
                            <button type="submit" class="btn btn-primary btn-lg">Login</button>
                        </div>
                        <p class="text-center"><?php echo htmlspecialchars($server_name); ?> &copy; <?php echo date("Y"); ?></p>
                    </form>
                </div>
            </div>
        </div>
        <script type="text/javascript" src="js/jquery.min.js"></script>
        <script type="text/javascript" src="bootstrap5/js/bootstrap.bundle.min.js"></script>
        <script src="js/pace.min.js"></script>
        
        <!-- Font Size Toggle Script -->
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const fontToggle = document.getElementById('fontSizeToggle');
            if (fontToggle) {
                fontToggle.addEventListener('click', function() {
                    // Send AJAX request to toggle font size
                    fetch('api/font-size-toggle.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: 'action=toggle'
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Toggle the class on body
                            document.body.classList.toggle('large-fonts', data.large_fonts);
                            // Toggle active state on button
                            fontToggle.classList.toggle('active', data.large_fonts);
                        }
                    })
                    .catch(error => console.error('Error toggling font size:', error));
                });
            }
        });
        </script>
    </body>
</html>
