<?php
// Set 403 Forbidden header immediately
http_response_code(403);

require("/docker/whp/web/libs/security.php");
require('/docker/whp/web/configs/config.php');
require('/docker/whp/web/libs/network.php');
require('/docker/whp/web/libs/security_manager.php');

$SecMan = new security_wrapper();
$NetInfo = new network_info();
$SecManager = new security_manager();

$client_ip = $NetInfo->get_client_ip();
$blocked_info = $SecManager->is_ip_blocked($client_ip);

if (!$blocked_info) {
    // Not blocked, redirect to login
    header('Location: /login.php');
    exit();
}

// Determine block expiry information
$expires_text = 'Never';
$is_indefinite = false;

if (!empty($blocked_info['expires_at'])) {
    if ($blocked_info['expires_at'] === '9999-12-31 23:59:59') {
        $expires_text = 'Indefinitely';
        $is_indefinite = true;
    } else {
        $expires_time = strtotime($blocked_info['expires_at']);
        $current_time = time();
        $remaining_time = $expires_time - $current_time;
        
        if ($remaining_time > 0) {
            if ($remaining_time < 3600) {
                $remaining_minutes = ceil($remaining_time / 60);
                $expires_text = $remaining_minutes . ' minute' . ($remaining_minutes != 1 ? 's' : '');
            } elseif ($remaining_time < 86400) {
                $remaining_hours = ceil($remaining_time / 3600);
                $expires_text = $remaining_hours . ' hour' . ($remaining_hours != 1 ? 's' : '');
            } else {
                $remaining_days = ceil($remaining_time / 86400);
                $expires_text = $remaining_days . ' day' . ($remaining_days != 1 ? 's' : '');
            }
        } else {
            // Block has expired
            $expires_text = 'Expired (you can try logging in again)';
        }
    }
} elseif (isset($blocked_info['unblock_time'])) {
    // Legacy format compatibility
    $remaining_time = $blocked_info['unblock_time'] - time();
    if ($remaining_time > 0) {
        $remaining_minutes = ceil($remaining_time / 60);
        $expires_text = $remaining_minutes . ' minute' . ($remaining_minutes != 1 ? 's' : '');
    } else {
        $expires_text = 'Expired (you can try logging in again)';
    }
}

// Get the service and reason information
$service = !empty($blocked_info['service']) ? htmlspecialchars($blocked_info['service']) : 'Security System';
$reason = !empty($blocked_info['reason']) ? htmlspecialchars($blocked_info['reason']) : 'Security violation detected';
$failed_attempts = isset($blocked_info['failed_attempts']) ? $blocked_info['failed_attempts'] : 0;
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Access Blocked - Web Hosting Panel</title>

        <!-- Bootstrap -->
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <link href="css/waves.min.css" type="text/css" rel="stylesheet">
        <link rel="stylesheet" href="css/nanoscroller.css">
        <link href="css/style.css" type="text/css" rel="stylesheet">
        <link href="font-awesome/css/font-awesome.min.css" rel="stylesheet">
        <link href="css/themify-icons.css" rel="stylesheet">
        <link href="css/color.css" rel="stylesheet">
    </head>
    <body class="account">
        <div class="container">
            <div class="row">
                <div class="account-col text-center">
                    <h1><i class="fa fa-ban text-danger"></i> Access Blocked</h1>
                    <h3>Your IP address has been temporarily blocked</h3>
                    
                    <div class="alert alert-danger">
                        <h4><i class="fa fa-exclamation-triangle"></i> Security Alert</h4>
                        <p>Your IP address <strong><?php echo htmlspecialchars($client_ip); ?></strong> has been blocked from accessing this service.</p>
                        
                        <p><strong>Blocked Service:</strong> <?php echo $service; ?></p>
                        <p><strong>Reason:</strong> <?php echo $reason; ?></p>
                        <?php if ($failed_attempts > 0): ?>
                        <p><strong>Failed attempts:</strong> <?php echo $failed_attempts; ?></p>
                        <?php endif; ?>
                        
                        <?php if ($is_indefinite): ?>
                        <p><strong>Block Duration:</strong> <span class="text-danger">Indefinite</span></p>
                        <p>This block will not expire automatically. Please contact your system administrator.</p>
                        <?php elseif ($expires_text === 'Expired (you can try logging in again)'): ?>
                        <p>Your block has expired. You can now try logging in again.</p>
                        <a href="/login.php" class="btn btn-primary">Go to Login</a>
                        <?php else: ?>
                        <p><strong>Block expires in:</strong> <?php echo $expires_text; ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="alert alert-info">
                        <h5><i class="fa fa-info-circle"></i> What happened?</h5>
                        <?php if ($failed_attempts > 0): ?>
                        <p>This block was automatically applied after <?php echo $failed_attempts; ?> failed login attempts within a short time period.</p>
                        <?php endif; ?>
                        <p>This is a security measure to protect against unauthorized access and attacks.</p>
                    </div>
                    
                    <div class="alert alert-warning">
                        <h5><i class="fa fa-clock-o"></i> Need immediate access?</h5>
                        <p>If you need immediate access and believe this is an error, please contact your system administrator.</p>
                        <p>Administrators can unblock your IP through the security management panel.</p>
                    </div>
                    
                    <p class="text-muted">Web Hosting Panel &copy; <?php echo date("Y"); ?></p>
                </div>
            </div>
        </div>
        
        <script type="text/javascript" src="js/jquery.min.js"></script>
        <script type="text/javascript" src="bootstrap/js/bootstrap.min.js"></script>
        <script src="js/pace.min.js"></script>
        
        <?php if (!$is_indefinite && isset($remaining_time) && $remaining_time > 0): ?>
        <script>
        // Auto-refresh when block expires
        setTimeout(function() {
            window.location.reload();
        }, <?php echo $remaining_time * 1000; ?>);
        
        // Update countdown every minute
        var remainingTime = <?php echo $remaining_time; ?>;
        setInterval(function() {
            remainingTime--;
            if (remainingTime <= 0) {
                window.location.reload();
            }
        }, 1000);
        </script>
        <?php endif; ?>
    </body>
</html> 