<?php
// PostgreSQL Password Entry Form
// Similar to mysql-password-entry.php

// Check if user is authenticated
if (!defined('AUTH_USER')) {
    header('Location: login.php');
    exit();
}

$error_message = '';
if (isset($_GET['error'])) {
    $error_message = $_GET['error'];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['postgresql_password'])) {
    session_start();
    // Store password in session temporarily for SSO
    $_SESSION['postgresql_password_' . AUTH_USER] = $_POST['postgresql_password'];
    // Redirect back to Adminer SSO
    header('Location: adminer-sso.php');
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>PostgreSQL Password - <?php echo htmlspecialchars(AUTH_USER); ?></title>
    <link href="bootstrap5/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 50px;
        }
        .container {
            max-width: 500px;
        }
        .card {
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fa fa-key"></i> PostgreSQL Password Required</h4>
            </div>
            <div class="card-body">
                <?php if ($error_message): ?>
                    <div class="alert alert-danger">
                        <strong>Error:</strong> <?php echo htmlspecialchars($error_message); ?>
                    </div>
                <?php endif; ?>
                
                <div class="alert alert-info">
                    <strong>Authentication Required</strong><br>
                    Your PostgreSQL user <code><?php echo htmlspecialchars(AUTH_USER . '_pg'); ?></code> already exists. 
                    Please enter your PostgreSQL password to access Adminer.
                </div>
                
                <form method="POST" action="">
                    <div class="mb-3">
                        <label for="postgresql_password" class="form-label">PostgreSQL Password</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fa fa-lock"></i></span>
                            <input type="password" class="form-control" id="postgresql_password" name="postgresql_password" required autocomplete="off">
                            <button type="button" class="btn btn-outline-secondary" onclick="togglePassword()" tabindex="-1">
                                <i class="fa fa-eye" id="toggleIcon"></i>
                            </button>
                        </div>
                        <div class="form-text">
                            This is the password for your PostgreSQL database user, not your WHP login password.
                        </div>
                    </div>
                    
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-sign-in-alt"></i> Continue to Adminer
                        </button>
                        <a href="index.php?page=postgresql-management" class="btn btn-secondary">
                            <i class="fa fa-arrow-left"></i> Back to PostgreSQL Management
                        </a>
                    </div>
                </form>
                
                <div class="alert alert-light mt-3">
                    <small>
                        <strong><i class="fa fa-info-circle"></i> Need Help?</strong><br>
                        If you don't remember your PostgreSQL password, contact your system administrator or 
                        use the PostgreSQL Management page to reset your user password.
                    </small>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        function togglePassword() {
            const passwordField = document.getElementById('postgresql_password');
            const toggleIcon = document.getElementById('toggleIcon');
            
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
            } else {
                passwordField.type = 'password';
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
            }
        }
        
        // Focus on password field when page loads
        document.getElementById('postgresql_password').focus();
    </script>
</body>
</html>