#!/bin/bash

echo "Enabling ProFTPD Debug Logging"
echo "==============================="

# Stop ProFTPD service
echo "Stopping ProFTPD..."
systemctl stop proftpd
sleep 3

# Kill any hanging ProFTPD processes
echo "Cleaning up any hanging processes..."
pkill -9 proftpd 2>/dev/null || true

# Backup current config
echo "Backing up current configuration..."
cp /etc/proftpd/proftpd.conf /etc/proftpd/proftpd.conf.backup

# Add debug logging to the config
echo "Adding debug logging configuration..."
cat >> /etc/proftpd/proftpd.conf << 'EOF'

# Debug logging for troubleshooting
DebugLevel 5
SyslogLevel info
TraceLog /var/log/proftpd/trace.log
Trace DEFAULT:10 auth:10 command:10 response:10

EOF

# Create log directory and files
echo "Setting up log files..."
mkdir -p /var/log/proftpd
touch /var/log/proftpd/proftpd.log
touch /var/log/proftpd/trace.log
touch /var/log/proftpd/auth.log
touch /var/log/proftpd/access.log

# Set proper permissions
chown -R nobody:nobody /var/log/proftpd
chmod 644 /var/log/proftpd/*.log

# Start ProFTPD
echo "Starting ProFTPD with debug logging..."
systemctl start proftpd

# Check status
echo "ProFTPD Status:"
systemctl status proftpd --no-pager -l

echo ""
echo "Debug logging enabled!"
echo "Log files location: /var/log/proftpd/"
echo ""
echo "To monitor logs in real-time during FTP testing:"
echo "  tail -f /var/log/proftpd/trace.log"
echo "  tail -f /var/log/proftpd/proftpd.log"
echo ""
echo "To test FTP connection:"
echo "  ftp 192.168.1.105"
echo "  Username: shadowdao"
echo "  Password: (user's system password)" 