-- Rollback async site creation changes
-- This migration removes the container deployment queue system that was causing issues

USE whp;

-- First, check if queue_id column exists and remove foreign key constraint
SET @constraint_name = (
    SELECT CONSTRAINT_NAME 
    FROM information_schema.KEY_COLUMN_USAGE 
    WHERE TABLE_SCHEMA = 'whp' 
    AND TABLE_NAME = 'sites' 
    AND COLUMN_NAME = 'queue_id' 
    AND REFERENCED_TABLE_NAME = 'container_deployment_queue'
    LIMIT 1
);

-- Drop the foreign key constraint if it exists
SET @sql = IF(@constraint_name IS NOT NULL, 
    CONCAT('ALTER TABLE sites DROP FOREIGN KEY ', @constraint_name), 
    'SELECT "No foreign key constraint found" as message'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Drop the queue_id column if it exists
ALTER TABLE sites DROP COLUMN IF EXISTS queue_id;

-- Now we can safely drop the container deployment queue table
DROP TABLE IF EXISTS container_deployment_queue;

-- Note: No other database changes needed as the async system was self-contained
-- All other functionality remains intact