<?php
// Permission checking is now handled by the permission system in auto-prepend.php

require_once('/docker/whp/web/libs/security_manager.php');
require_once('/docker/whp/web/libs/log_monitor_manager.php');
$SecManager = new security_manager();
$LogMonitor = new log_monitor_manager();

$message = '';
$message_type = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'unblock_ip':
                if (!empty($_POST['ip_address'])) {
                    $result = $SecManager->unblock_ip($_POST['ip_address']);
                    if ($result) {
                        $message = 'IP address unblocked successfully: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error unblocking IP address';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'block_ip':
                if (!empty($_POST['ip_address'])) {
                    $reason = !empty($_POST['reason']) ? $_POST['reason'] : 'Manual block';
                    $result = $SecManager->block_ip($_POST['ip_address'], $reason);
                    if ($result) {
                        $message = 'IP address blocked successfully: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error blocking IP address (may be exempted)';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'add_exemption':
                if (!empty($_POST['ip_address'])) {
                    $description = !empty($_POST['description']) ? $_POST['description'] : '';
                    $result = $SecManager->add_exemption_ip($_POST['ip_address'], $description);
                    if ($result) {
                        $message = 'IP address added to exemption list: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error adding IP to exemption list';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'remove_exemption':
                if (!empty($_POST['ip_address'])) {
                    $result = $SecManager->remove_exemption_ip($_POST['ip_address']);
                    if ($result) {
                        $message = 'IP address removed from exemption list: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error removing IP from exemption list';
                        $message_type = 'danger';
                    }
                }
                break;
            case 'update_log_monitoring':
                // Define allowed configuration keys for security
                $allowed_config_keys = [
                    'ssh_monitoring_enabled', 'ftp_monitoring_enabled',
                    'max_ssh_attempts', 'max_ftp_attempts',
                    'ssh_block_duration', 'ftp_block_duration',
                    'ssh_log_file', 'ftp_log_file',
                    'log_check_interval', 'blocking_method',
                    'docker_network_preserve'
                ];
                
                $config_updates = array();
                
                foreach ($_POST as $key => $value) {
                    if (strpos($key, 'config_') === 0) {
                        $setting_name = substr($key, 7); // Remove 'config_' prefix
                        if (in_array($setting_name, $allowed_config_keys)) {
                            $config_updates[$setting_name] = $value;
                        }
                    }
                }
                
                $success_count = 0;
                foreach ($config_updates as $setting => $value) {
                    if ($LogMonitor->set_config($setting, $value)) {
                        $success_count++;
                    }
                }
                
                if ($success_count > 0) {
                    $message = "Updated $success_count log monitoring settings successfully";
                    $message_type = 'success';
                } else {
                    $message = 'No settings were updated';
                    $message_type = 'warning';
                }
                break;
            case 'unblock_service_ip':
                if (!empty($_POST['service']) && !empty($_POST['ip_address'])) {
                    $result = $LogMonitor->unblock_service_ip($_POST['service'], $_POST['ip_address']);
                    if ($result) {
                        $message = 'IP address unblocked from ' . strtoupper($_POST['service']) . ' service: ' . $_POST['ip_address'];
                        $message_type = 'success';
                    } else {
                        $message = 'Error unblocking IP address from service';
                        $message_type = 'danger';
                    }
                }
                break;
        }
    }
}

// Get data
$blocked_ips = $SecManager->get_blocked_ips();
$exemption_ips = $SecManager->get_exemption_ips();
$security_stats = $SecManager->get_security_stats();
$recent_logins = $SecManager->get_all_recent_logins(10);

// Get log monitoring data
$log_config = $LogMonitor->get_all_config();
$service_stats = $LogMonitor->get_service_stats();
$service_blocked_ips = $LogMonitor->get_service_blocked_ips();

// Get access statistics
require_once('/docker/whp/web/libs/permission_manager.php');
$PermManager = new permission_manager();
$access_stats = $PermManager->get_system_access_stats(30);
?>
<?php if (!empty($message)): ?>
<div class="row">
    <div class="col-sm-12">
        <div class="alert alert-<?php echo $message_type; ?> alert-dismissible" role="alert">
            <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <?php echo htmlspecialchars($message); ?>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- Security Statistics -->
<div class="row g-4 mb-4">
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Blocked IPs</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-danger"><?php echo $security_stats['blocked_ips']; ?></h2>
                <p class="mb-0">Currently blocked IP addresses</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Failed Attempts (24h)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-warning"><?php echo $security_stats['failed_attempts_24h']; ?></h2>
                <p class="mb-0">Failed login attempts in last 24 hours</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Exempted IPs</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-success"><?php echo $security_stats['exemption_ips']; ?></h2>
                <p class="mb-0">IP addresses in exemption list</p>
            </div>
        </div>
    </div>
</div>

<!-- SSH/FTP Service Statistics -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">SSH Blocked IPs</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-danger"><?php echo $service_stats['ssh']['blocked_ips']; ?></h2>
                <p class="mb-0">Currently blocked from SSH</p>
                <?php if (!$service_stats['ssh']['monitoring_enabled']): ?>
                <small class="text-muted">(Monitoring disabled)</small>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">SSH Failed Attempts (24h)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-warning"><?php echo $service_stats['ssh']['failed_attempts_24h']; ?></h2>
                <p class="mb-0">SSH login failures</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">FTP Blocked IPs</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-danger"><?php echo $service_stats['ftp']['blocked_ips']; ?></h2>
                <p class="mb-0">Currently blocked from FTP</p>
                <?php if (!$service_stats['ftp']['monitoring_enabled']): ?>
                <small class="text-muted">(Monitoring disabled)</small>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">FTP Failed Attempts (24h)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-warning"><?php echo $service_stats['ftp']['failed_attempts_24h']; ?></h2>
                <p class="mb-0">FTP login failures</p>
            </div>
        </div>
    </div>
</div>

<!-- Access Statistics -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Total Access Attempts (30d)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-info"><?php echo $access_stats['total_attempts']; ?></h2>
                <p class="mb-0">Total page/API access attempts</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Denied Access (30d)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-danger"><?php echo $access_stats['denied_attempts']; ?></h2>
                <p class="mb-0">Permission denied attempts</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Success Rate (30d)</h5>
            </div>
            <div class="card-body text-center">
                <h2 class="text-success"><?php echo $access_stats['success_rate']; ?>%</h2>
                <p class="mb-0">Successful access rate</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Top Denied Page</h5>
            </div>
            <div class="card-body text-center">
                <?php if (!empty($access_stats['top_denied_pages'])): ?>
                <h2 class="text-warning"><?php echo htmlspecialchars($access_stats['top_denied_pages'][0]['page']); ?></h2>
                <p class="mb-0"><?php echo $access_stats['top_denied_pages'][0]['count']; ?> denials</p>
                <?php else: ?>
                <h2 class="text-muted">-</h2>
                <p class="mb-0">No denials</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Log Monitoring Configuration -->
<div class="row g-4 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">SSH/FTP Log Monitoring Configuration</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo get_csrf_token(); ?>">
                    <input type="hidden" name="action" value="update_log_monitoring">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="mb-3">SSH Monitoring</h6>
                            
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="config_ssh_monitoring_enabled" value="1" 
                                           <?php echo ($LogMonitor->get_config('ssh_monitoring_enabled') == '1') ? 'checked' : ''; ?>>
                                    <label class="form-check-label">Enable SSH monitoring</label>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Max SSH attempts before block</label>
                                <input type="number" class="form-control" name="config_max_ssh_attempts" 
                                       value="<?php echo htmlspecialchars($LogMonitor->get_config('max_ssh_attempts', '5')); ?>" min="1" max="50">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">SSH block duration (seconds)</label>
                                <select class="form-select" name="config_ssh_block_duration">
                                    <?php 
                                    $ssh_duration = $LogMonitor->get_config('ssh_block_duration', '3600');
                                    $durations = [
                                        '300' => '5 minutes',
                                        '600' => '10 minutes',
                                        '1800' => '30 minutes',
                                        '3600' => '1 hour',
                                        '7200' => '2 hours',
                                        '86400' => '24 hours'
                                    ];
                                    foreach ($durations as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($ssh_duration == $value) ? 'selected' : ''; ?>>
                                        <?php echo $label; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">SSH log file path</label>
                                <input type="text" class="form-control" name="config_ssh_log_file" 
                                       value="<?php echo htmlspecialchars($LogMonitor->get_config('ssh_log_file', '/var/log/auth.log')); ?>">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="mb-3">FTP Monitoring</h6>
                            
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="config_ftp_monitoring_enabled" value="1"
                                           <?php echo ($LogMonitor->get_config('ftp_monitoring_enabled') == '1') ? 'checked' : ''; ?>>
                                    <label class="form-check-label">Enable FTP monitoring</label>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Max FTP attempts before block</label>
                                <input type="number" class="form-control" name="config_max_ftp_attempts" 
                                       value="<?php echo htmlspecialchars($LogMonitor->get_config('max_ftp_attempts', '5')); ?>" min="1" max="50">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">FTP block duration (seconds)</label>
                                <select class="form-select" name="config_ftp_block_duration">
                                    <?php 
                                    $ftp_duration = $LogMonitor->get_config('ftp_block_duration', '3600');
                                    foreach ($durations as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($ftp_duration == $value) ? 'selected' : ''; ?>>
                                        <?php echo $label; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">FTP log file path</label>
                                <input type="text" class="form-control" name="config_ftp_log_file" 
                                       value="<?php echo htmlspecialchars($LogMonitor->get_config('ftp_log_file', '/var/log/proftpd/proftpd.log')); ?>">
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="mb-3">General Settings</h6>
                            
                            <div class="mb-3">
                                <label class="form-label">Log check interval (seconds)</label>
                                <select class="form-select" name="config_log_check_interval">
                                    <?php 
                                    $check_interval = $LogMonitor->get_config('log_check_interval', '300');
                                    $intervals = [
                                        '60' => '1 minute',
                                        '300' => '5 minutes',
                                        '600' => '10 minutes',
                                        '1800' => '30 minutes'
                                    ];
                                    foreach ($intervals as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($check_interval == $value) ? 'selected' : ''; ?>>
                                        <?php echo $label; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="mb-3">Advanced Options</h6>
                            
                            <div class="mb-3">
                                <label class="form-label">IP Blocking Method</label>
                                <select class="form-select" name="config_blocking_method">
                                    <?php 
                                    $blocking_method = $LogMonitor->get_config('blocking_method', 'service');
                                    $methods = [
                                        'service' => 'Service-Level Blocking (Recommended)',
                                        'iptables' => 'Firewall-Level Blocking (iptables)'
                                    ];
                                    foreach ($methods as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($blocking_method == $value) ? 'selected' : ''; ?>>
                                        <?php echo $label; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                                <small class="form-text text-muted">Service-level blocking uses configuration files and graceful service reloads (safer for Docker)</small>
                            </div>
                            
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="config_docker_network_preserve" value="1"
                                           <?php echo ($LogMonitor->get_config('docker_network_preserve') == '1') ? 'checked' : ''; ?>>
                                    <label class="form-check-label">Preserve Docker networking</label>
                                    <small class="form-text text-muted">When using iptables: block only specific services instead of all traffic from IP</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Update Configuration</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mb-4">
    <!-- Block IP Panel -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Block IP Address</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo get_csrf_token(); ?>">
                    <input type="hidden" name="action" value="block_ip">
                    <div class="mb-3">
                        <label for="block_ip" class="form-label">IP Address</label>
                        <input type="text" class="form-control" id="block_ip" name="ip_address" placeholder="192.168.1.100" required>
                    </div>
                    <div class="mb-3">
                        <label for="block_reason" class="form-label">Reason (optional)</label>
                        <input type="text" class="form-control" id="block_reason" name="reason" placeholder="Manual block">
                    </div>
                    <button type="submit" class="btn btn-danger">Block IP</button>
                </form>
            </div>
        </div>
    </div>
    <!-- Add to Exemption List Panel -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Add to Exemption List</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo get_csrf_token(); ?>">
                    <input type="hidden" name="action" value="add_exemption">
                    <div class="mb-3">
                        <label for="exemption_ip" class="form-label">IP Address</label>
                        <input type="text" class="form-control" id="exemption_ip" name="ip_address" placeholder="192.168.1.100" required>
                    </div>
                    <div class="mb-3">
                        <label for="exemption_description" class="form-label">Description (optional)</label>
                        <input type="text" class="form-control" id="exemption_description" name="description" placeholder="Office, Home, etc.">
                    </div>
                    <button type="submit" class="btn btn-success">Add to Exemption List</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row g-4">
    <!-- Blocked IPs Table -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Blocked IPs</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr><th>IP Address</th><th width="120">Action</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($blocked_ips as $ip): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($ip); ?></td>
                                <td>
                                    <form method="POST" action="" style="display:inline;">
                                        <input type="hidden" name="csrf_token" value="<?php echo get_csrf_token(); ?>">
                                        <input type="hidden" name="action" value="unblock_ip">
                                        <input type="hidden" name="ip_address" value="<?php echo htmlspecialchars($ip); ?>">
                                        <button type="submit" class="btn btn-warning btn-sm">Unblock</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Exemption List Table -->
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header">
                <h5 class="card-title mb-0">Exempted IPs</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr><th>IP Address</th><th>Description</th><th width="120">Action</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($exemption_ips as $ip): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($ip['ip_address']); ?></td>
                                <td><?php echo htmlspecialchars($ip['description']); ?></td>
                                <td>
                                    <form method="POST" action="" style="display:inline;">
                                        <input type="hidden" name="csrf_token" value="<?php echo get_csrf_token(); ?>">
                                        <input type="hidden" name="action" value="remove_exemption">
                                        <input type="hidden" name="ip_address" value="<?php echo htmlspecialchars($ip['ip_address']); ?>">
                                        <button type="submit" class="btn btn-danger btn-sm">Remove</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Service Blocked IPs -->
<?php if (!empty($service_blocked_ips)): ?>
<div class="row g-4 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Service Blocked IPs (SSH/FTP)</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Service</th>
                                <th>IP Address</th>
                                <th>Blocked Time</th>
                                <th>Unblock Time</th>
                                <th>Failed Attempts</th>
                                <th>Reason</th>
                                <th width="120">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($service_blocked_ips as $blocked): ?>
                            <tr>
                                <td><span class="badge bg-<?php echo $blocked['service_type'] == 'ssh' ? 'primary' : 'info'; ?>"><?php echo strtoupper($blocked['service_type']); ?></span></td>
                                <td><code><?php echo htmlspecialchars($blocked['ip_address']); ?></code></td>
                                <td>
                                    <small title="<?php echo date('Y-m-d H:i:s', $blocked['block_time']); ?>">
                                        <?php 
                                        $time_ago = time() - $blocked['block_time'];
                                        if ($time_ago < 60) {
                                            echo 'Just now';
                                        } elseif ($time_ago < 3600) {
                                            echo floor($time_ago / 60) . 'm ago';
                                        } elseif ($time_ago < 86400) {
                                            echo floor($time_ago / 3600) . 'h ago';
                                        } else {
                                            echo floor($time_ago / 86400) . 'd ago';
                                        }
                                        ?>
                                    </small>
                                </td>
                                <td>
                                    <small title="<?php echo date('Y-m-d H:i:s', $blocked['unblock_time']); ?>">
                                        <?php 
                                        $time_left = $blocked['unblock_time'] - time();
                                        if ($time_left > 86400) {
                                            echo floor($time_left / 86400) . 'd ' . floor(($time_left % 86400) / 3600) . 'h';
                                        } elseif ($time_left > 3600) {
                                            echo floor($time_left / 3600) . 'h ' . floor(($time_left % 3600) / 60) . 'm';
                                        } elseif ($time_left > 60) {
                                            echo floor($time_left / 60) . 'm';
                                        } else {
                                            echo 'Soon';
                                        }
                                        ?>
                                    </small>
                                </td>
                                <td><span class="badge bg-warning"><?php echo $blocked['failed_attempts']; ?></span></td>
                                <td class="text-truncate" style="max-width: 200px;" title="<?php echo htmlspecialchars($blocked['reason']); ?>">
                                    <?php echo htmlspecialchars(strlen($blocked['reason']) > 30 ? substr($blocked['reason'], 0, 30) . '...' : $blocked['reason']); ?>
                                </td>
                                <td>
                                    <form method="POST" action="" style="display:inline;">
                                        <input type="hidden" name="csrf_token" value="<?php echo get_csrf_token(); ?>">
                                        <input type="hidden" name="action" value="unblock_service_ip">
                                        <input type="hidden" name="service" value="<?php echo htmlspecialchars($blocked['service_type']); ?>">
                                        <input type="hidden" name="ip_address" value="<?php echo htmlspecialchars($blocked['ip_address']); ?>">
                                        <button type="submit" class="btn btn-warning btn-sm">Unblock</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Recent Successful Logins -->
<div class="row g-4 mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Recent Successful Logins</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Username</th>
                                <th>IP Address</th>
                                <th>Login Time</th>
                                <th>User Agent</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($recent_logins)): ?>
                            <tr>
                                <td colspan="4" class="text-center text-muted">No recent logins found</td>
                            </tr>
                            <?php else: ?>
                            <?php foreach ($recent_logins as $login): ?>
                            <tr>
                                <td><strong><?php echo htmlspecialchars($login['username']); ?></strong></td>
                                <td>
                                    <code><?php echo htmlspecialchars($login['ip_address']); ?></code>
                                </td>
                                <td>
                                    <span title="<?php echo date('Y-m-d H:i:s', $login['login_time']); ?>">
                                        <?php 
                                        $time_ago = time() - $login['login_time'];
                                        if ($time_ago < 60) {
                                            echo 'Just now';
                                        } elseif ($time_ago < 3600) {
                                            echo floor($time_ago / 60) . ' minutes ago';
                                        } elseif ($time_ago < 86400) {
                                            echo floor($time_ago / 3600) . ' hours ago';
                                        } else {
                                            echo floor($time_ago / 86400) . ' days ago';
                                        }
                                        ?>
                                    </span>
                                </td>
                                <td class="text-truncate" style="max-width: 300px;" title="<?php echo htmlspecialchars($login['user_agent'], ENT_QUOTES, 'UTF-8'); ?>">
                                    <?php 
                                    $user_agent = htmlspecialchars($login['user_agent'], ENT_QUOTES, 'UTF-8');
                                    echo strlen($user_agent) > 60 ? substr($user_agent, 0, 60) . '...' : $user_agent; 
                                    ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div> 