#!/usr/bin/env bash
# Example update script - demonstrates proper structure and logging

set -e

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

echo -e "${BLUE}Running example update script...${NC}"

# Example: Create/update a configuration file idempotently
CONFIG_FILE="/tmp/whp_example.conf"

if [ ! -f "$CONFIG_FILE" ]; then
    echo -e "${YELLOW}Creating example configuration file...${NC}"
    cat > "$CONFIG_FILE" << 'EOF'
# WHP Example Configuration
# This is just for demonstration
example_setting=enabled
log_level=info
EOF
    echo -e "${GREEN}Configuration file created${NC}"
else
    echo -e "${GREEN}Configuration file already exists${NC}"
fi

# Example: Ensure a directory exists
EXAMPLE_DIR="/tmp/whp_example_dir"
if [ ! -d "$EXAMPLE_DIR" ]; then
    mkdir -p "$EXAMPLE_DIR"
    echo -e "${YELLOW}Created directory: $EXAMPLE_DIR${NC}"
else
    echo -e "${GREEN}Directory already exists${NC}"
fi

# Example: Set proper permissions (idempotent operation)
chmod 755 "$EXAMPLE_DIR" 2>/dev/null || true

echo -e "${GREEN}Example update script completed successfully${NC}"