<?php
// Simple MySQL password entry as fallback
// This is used when the stored MySQL password is not available

// Check if user is authenticated
if (!defined('AUTH_USER') || empty(AUTH_USER)) {
    header("Location: index.php");
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mysql_password'])) {
    $mysql_password = $_POST['mysql_password'];
    
    // Store the password in session for this request
    session_start();
    $_SESSION['mysql_password_' . AUTH_USER] = $mysql_password;
    
    // Redirect back to phpMyAdmin SSO
    header("Location: phpmyadmin-sso.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MySQL Password Required - Web Hosting Panel</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #333;
            margin: 0 0 10px 0;
            font-size: 24px;
        }
        .header p {
            color: #666;
            margin: 0;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #333;
            font-weight: bold;
        }
        .form-group input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            box-sizing: border-box;
        }
        .form-group input[type="password"]:focus {
            outline: none;
            border-color: #007cba;
            box-shadow: 0 0 0 2px rgba(0,124,186,0.2);
        }
        .submit-btn {
            width: 100%;
            padding: 12px;
            background-color: #007cba;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        .submit-btn:hover {
            background-color: #005a87;
        }
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        .back-link a {
            color: #007cba;
            text-decoration: none;
        }
        .back-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>MySQL Password Required</h1>
            <p>Please enter your MySQL password to access phpMyAdmin</p>
        </div>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="mysql_password">MySQL Password:</label>
                <input type="password" id="mysql_password" name="mysql_password" required>
            </div>
            
            <button type="submit" class="submit-btn">Continue to phpMyAdmin</button>
        </form>
        
        <div class="back-link">
            <a href="index.php">← Back to Control Panel</a>
        </div>
    </div>
</body>
</html> 