#!/usr/bin/env php
<?php

require_once(__DIR__ . '/../web-files/configs/config.php');
require_once(__DIR__ . '/../web-files/libs/mysqlmgmt.php');
require_once(__DIR__ . '/../web-files/libs/WordPressManager.php');

use WHP\WordPressManager;

try {
    echo "Testing WordPress backup creation...\n";
    
    $wpManager = new WordPressManager();
    
    // Get site info
    $mysql = new mysqlmgmt();
    $db = $mysql->getMySQLConnection();
    $db->exec("USE whp");
    
    $stmt = $db->prepare("SELECT * FROM wordpress_sites WHERE id = 1");
    $stmt->execute();
    $site = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$site) {
        die("Site not found\n");
    }
    
    echo "Site: " . $site['domain'] . "\n";
    echo "Database: " . $site['database_name'] . "\n";
    
    // Create backup using reflection to access private method
    $method = new ReflectionMethod($wpManager, 'createBackup');
    $method->setAccessible(true);
    
    echo "Creating backup...\n";
    $result = $method->invoke($wpManager, $site, 'test');
    
    echo "Backup result:\n";
    print_r($result);
    
    // Check queue immediately after
    echo "\nChecking backup queue...\n";
    $stmt = $db->query("SELECT * FROM backup_queue WHERE created_at >= NOW() - INTERVAL 1 MINUTE ORDER BY created_at DESC");
    $queued = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Recently queued backups:\n";
    foreach ($queued as $q) {
        echo "- " . $q['backup_type'] . ": " . $q['backup_name'] . " (status: " . $q['status'] . ")\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
}