-- Add successful_logins table for login tracking
-- Migration: 2025-08-19_add-successful-logins-table.sql

-- Check if table already exists and create if not
CREATE TABLE IF NOT EXISTS successful_logins (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT NOT NULL,
    ip_address TEXT NOT NULL,
    login_time INTEGER NOT NULL,
    user_agent TEXT
);

-- Create indexes for better performance
CREATE INDEX IF NOT EXISTS idx_successful_logins_user ON successful_logins(username);
CREATE INDEX IF NOT EXISTS idx_successful_logins_time ON successful_logins(login_time);

-- Log the migration
INSERT OR IGNORE INTO schema_version (version, applied_at, description) 
VALUES ('2025.08.19.001', datetime('now'), 'Add successful_logins table for login tracking');