-- Announcements table for Web Hosting Panel
-- This script creates the announcements table for server announcements

USE whp;

-- Create announcements table
CREATE TABLE IF NOT EXISTS announcements (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    markdown_content TEXT NOT NULL,
    created_by VARCHAR(32) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    active BOOLEAN DEFAULT TRUE,
    priority INT DEFAULT 0,
    pinned BOOLEAN DEFAULT FALSE,
    INDEX idx_active (active),
    INDEX idx_priority (priority),
    INDEX idx_pinned (pinned),
    INDEX idx_created_by (created_by),
    INDEX idx_created_at (created_at)
);

-- Insert a sample announcement
INSERT IGNORE INTO announcements (title, content, markdown_content, created_by, priority) VALUES 
('Welcome to the Web Hosting Panel', 
'<p>Welcome to your new web hosting control panel. This panel allows you to manage your websites, databases, and other hosting features.</p><h3>Getting Started</h3><ul><li>Create databases in the Database Management section</li><li>Manage your domains in Domain Management</li><li>Check server status in the dashboard</li></ul>',
'Welcome to your new web hosting control panel. This panel allows you to manage your websites, databases, and other hosting features.\n\n### Getting Started\n\n- Create databases in the Database Management section\n- Manage your domains in Domain Management  \n- Check server status in the dashboard',
'root', 
1); 