#!/usr/bin/env php
<?php

// Simple script to check backup queue
require_once(__DIR__ . '/../web-files/configs/config.php');
require_once(__DIR__ . '/../web-files/libs/mysqlmgmt.php');

try {
    $mysql = new mysqlmgmt();
    $db = $mysql->getMySQLConnection();
    $db->exec("USE whp");
    
    echo "Recent backup queue entries:\n";
    echo str_repeat("-", 80) . "\n";
    
    $stmt = $db->query("
        SELECT id, target_id, user, backup_type, backup_name, status, priority, created_at, attempts 
        FROM backup_queue 
        WHERE created_at >= DATE_SUB(NOW(), INTERVAL 1 HOUR) 
        ORDER BY created_at DESC 
        LIMIT 20
    ");
    
    $entries = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($entries)) {
        echo "No recent backup queue entries found.\n";
    } else {
        foreach ($entries as $entry) {
            echo sprintf(
                "ID: %d | Target: %d | User: %s | Type: %s | Name: %s | Status: %s | Priority: %s | Created: %s | Attempts: %d\n",
                $entry['id'],
                $entry['target_id'],
                $entry['user'],
                $entry['backup_type'],
                $entry['backup_name'],
                $entry['status'],
                $entry['priority'],
                $entry['created_at'],
                $entry['attempts']
            );
        }
    }
    
    echo "\nRecent backup history entries:\n";
    echo str_repeat("-", 80) . "\n";
    
    $stmt = $db->query("
        SELECT id, target_id, user, backup_type, backup_name, status, started_at, completed_at 
        FROM backup_history 
        WHERE started_at >= DATE_SUB(NOW(), INTERVAL 1 HOUR) 
        ORDER BY started_at DESC 
        LIMIT 20
    ");
    
    $history = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($history)) {
        echo "No recent backup history entries found.\n";
    } else {
        foreach ($history as $entry) {
            echo sprintf(
                "ID: %d | Target: %d | User: %s | Type: %s | Name: %s | Status: %s | Started: %s | Completed: %s\n",
                $entry['id'],
                $entry['target_id'],
                $entry['user'],
                $entry['backup_type'],
                $entry['backup_name'],
                $entry['status'],
                $entry['started_at'] ?? 'NULL',
                $entry['completed_at'] ?? 'NULL'
            );
        }
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}