#!/bin/bash

# Post-update script for WHP
# Run this after git pull and rsync to ensure all external dependencies are available

echo "Running WHP post-update tasks..."

# Re-download xterm.js files if terminal feature is enabled
if [ -f "/etc/systemd/system/whp-terminal.service" ]; then
    echo "Terminal feature detected, re-downloading xterm.js files..."
    if [ -x "/root/whp/scripts/download-xterm.sh" ]; then
        /root/whp/scripts/download-xterm.sh
        echo "✓ xterm.js files updated"
    else
        echo "⚠ Warning: download-xterm.sh script not found or not executable"
    fi
else
    echo "Terminal feature not installed, skipping xterm.js download"
fi

# Sync any newly downloaded files to web root
echo "Syncing files to web root..."
rsync -av /root/whp/web-files/ /docker/whp/web/
echo "✓ Files synced to web root"

echo "Post-update tasks completed!"