-- Fix WordPress Tables Collation
-- Date: 2025-07-21
-- Description: Convert existing WordPress tables to utf8mb4_unicode_ci collation for consistency

USE whp;

-- Convert wp_cli_containers table
ALTER TABLE wp_cli_containers CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Convert wordpress_sites table
ALTER TABLE wordpress_sites CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Convert wp_recommended_plugins table
ALTER TABLE wp_recommended_plugins CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Convert wp_site_plugins table
ALTER TABLE wp_site_plugins CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Convert wp_update_history table
ALTER TABLE wp_update_history CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Convert wp_security_settings table
ALTER TABLE wp_security_settings CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Convert wp_login_tokens table (if exists)
ALTER TABLE wp_login_tokens CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Verify collation for all WordPress tables
SELECT 
    TABLE_NAME,
    TABLE_COLLATION
FROM INFORMATION_SCHEMA.TABLES 
WHERE TABLE_SCHEMA = 'whp' 
  AND TABLE_NAME LIKE 'wp_%'
ORDER BY TABLE_NAME;

-- Note: This migration is safe to run multiple times
-- The CONVERT statement will only change the collation if needed