-- Fix Announcements Newline Display
-- Date: 2025-07-23
-- Description: Fix newline handling in announcements markdown conversion

USE whp;

-- This is a code-only fix that updates the markdown_to_html() function
-- in announcement_manager.php to properly handle single newlines
-- No database schema changes are required

SELECT 'Fixed announcements newline display - single newlines now convert to <br> tags' AS fix_description;

-- Fix details:
-- 1. Updated markdown_to_html() function in announcement_manager.php
-- 2. Added proper handling of single newlines (\n) to convert them to <br> tags
-- 3. Preserved existing double newline (\n\n) to paragraph break functionality
-- 4. This ensures that line breaks in announcements are properly displayed

-- Before fix: Single newlines were ignored, only double newlines created paragraph breaks
-- After fix: Single newlines become <br> tags, double newlines still create paragraph breaks