# WHP Update Scripts - Staging Directory

This directory contains shell scripts that are pending release, similar to how SQL migrations work in `sql/migrations/staging/`.

## How It Works

1. **Development**: Create shell scripts in this `staging/` directory during development
2. **Build Process**: When `build-release.sh` runs, it moves scripts from `staging/` to a version directory
3. **Update Process**: The update system applies scripts from the version directories in order

## Script Requirements

### Naming Convention
- Format: `NNN_descriptive_name.sh`
- Three-digit prefix for ordering (001-999)
- Descriptive lowercase name with underscores
- Must have `.sh` extension

### Script Structure
All scripts MUST start with:
```bash
#!/usr/bin/env bash
set -e
```

### Security Requirements
1. **Shebang**: Must use `#!/usr/bin/env bash`
2. **Error Handling**: Use `set -e` for exit on error
3. **Idempotency**: Scripts must be safe to run multiple times
4. **No Dangerous Commands**: Scripts are validated before execution

## Example Script

```bash
#!/usr/bin/env bash
# Example update script - configure new feature

set -e

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${GREEN}Configuring new feature...${NC}"

# Your update logic here
# Remember: must be idempotent!

echo -e "${GREEN}Configuration completed successfully${NC}"
```

## Integration with Build System

The build-release.sh script automatically:
1. Detects scripts in this staging directory
2. Moves them to `scripts/updates/VERSION/` directory
3. Commits the organized scripts to git
4. Includes them in the release package

## Execution Order

During updates, scripts are executed:
1. **After SQL migrations** - Database changes happen first
2. **Before file synchronization** - Scripts can modify system configuration
3. **In version order** - Older versions first, then newer
4. **In filename order** - Within each version, by numerical prefix