-- Update Container Types with Actual Images
-- This script replaces the dummy container types with actual images from repo.anhonesthost.net

USE whp;

-- Clear existing container types (keeping the table structure)
DELETE FROM container_types;

-- Insert PHP container types for each PHP version
INSERT INTO container_types (name, description, base_image, min_cpu, min_memory, startup_env, user_variables, mount_options, listen_port, listen_port_tls, active) VALUES 
('PHP 7.4', 'Apache with PHP 7.4', 'repo.anhonesthost.net/cloud-hosting-platform/cac:php74', 0.25, 256, 
'{"uid": "${WHP_UID}", "user": "${WHP_USER}", "domain": "${WHP_DOMAIN}"}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/home/${WHP_USER}", "type": "bind"}]}',
443, 1, 1),

('PHP 8.0', 'Apache with PHP 8.0', 'repo.anhonesthost.net/cloud-hosting-platform/cac:php80', 0.25, 256, 
'{"uid": "${WHP_UID}", "user": "${WHP_USER}", "domain": "${WHP_DOMAIN}"}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/home/${WHP_USER}", "type": "bind"}]}',
443, 1, 1),

('PHP 8.1', 'Apache with PHP 8.1', 'repo.anhonesthost.net/cloud-hosting-platform/cac:php81', 0.25, 256, 
'{"uid": "${WHP_UID}", "user": "${WHP_USER}", "domain": "${WHP_DOMAIN}"}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/home/${WHP_USER}", "type": "bind"}]}',
443, 1, 1),

('PHP 8.2', 'Apache with PHP 8.2', 'repo.anhonesthost.net/cloud-hosting-platform/cac:php82', 0.25, 256, 
'{"uid": "${WHP_UID}", "user": "${WHP_USER}", "domain": "${WHP_DOMAIN}"}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/home/${WHP_USER}", "type": "bind"}]}',
443, 1, 1),

('PHP 8.3', 'Apache with PHP 8.3', 'repo.anhonesthost.net/cloud-hosting-platform/cac:php83', 0.25, 256, 
'{"uid": "${WHP_UID}", "user": "${WHP_USER}", "domain": "${WHP_DOMAIN}"}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/home/${WHP_USER}", "type": "bind"}]}',
443, 1, 1),

('PHP 8.4', 'Apache with PHP 8.4', 'repo.anhonesthost.net/cloud-hosting-platform/cac:php84', 0.25, 256, 
'{"uid": "${WHP_UID}", "user": "${WHP_USER}", "domain": "${WHP_DOMAIN}"}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/home/${WHP_USER}", "type": "bind"}]}',
443, 1, 1),

('Static Apache', 'Default Apache container for static content only', 'repo.anhonesthost.net/cloud-hosting-platform/whp-default:latest', 0.25, 256, 
'{}',
'{}',
'{"volumes": [{"source": "${WHP_HOME}/${WHP_DOMAIN}", "target": "/usr/local/apache2/htdocs", "type": "bind"}]}',
80, 0, 1);

-- Update the complete-database-setup.sql file to use these new container types
-- This ensures future deployments will use the actual images instead of dummy data 