<?php
require("/docker/whp/web/libs/security.php");
require('/docker/whp/web/configs/config.php');
require('/docker/whp/web/libs/network.php');
require('/docker/whp/web/libs/security_manager.php');
require('/docker/whp/web/libs/permission_checker.php');

// Function to check if current request is to an API endpoint
function is_api_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = $_SERVER['REQUEST_URI'];
    
    // Check if the script is in the API directory
    if (strpos($script_path, '/docker/whp/web/api/') !== false) {
        return true;
    }
    
    // Check if the request URI starts with /api/
    if (strpos($request_uri, '/api/') === 0) {
        return true;
    }
    
    return false;
}

// Function to check if current request is to Adminer
function is_adminer_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = $_SERVER['REQUEST_URI'];
    $script_name = basename($_SERVER['SCRIPT_NAME']);
    
    // Check if the script is adminer.php
    if ($script_name === 'adminer.php') {
        return true;
    }
    
    // Check if the request URI is for adminer
    if (strpos($request_uri, '/adminer.php') !== false) {
        return true;
    }
    
    // Check if the script path contains adminer.php
    if (strpos($script_path, 'adminer.php') !== false) {
        return true;
    }
    
    return false;
}

// Function to validate CSRF token
function validate_csrf_token() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $csrf_token = null;
        
        // Check for CSRF token in POST data first
        if (!empty($_POST['csrf_token'])) {
            $csrf_token = $_POST['csrf_token'];
        }
        // For API endpoints, check X-CSRF-Token header
        elseif (!empty($_SERVER['HTTP_X_CSRF_TOKEN'])) {
            $csrf_token = $_SERVER['HTTP_X_CSRF_TOKEN'];
        }
        
        if (empty($_SESSION['csrf_token']) || empty($csrf_token)) {
            return false;
        }
        
        // Use hash_equals to prevent timing attacks
        return hash_equals($_SESSION['csrf_token'], $csrf_token);
    }
    return true; // GET requests don't need CSRF validation
}

// Function to get CSRF token for forms
function get_csrf_token() {
    return isset($_SESSION['csrf_token']) ? $_SESSION['csrf_token'] : '';
}

$SecMan = new security_wrapper();
$NetInfo = new network_info();
$SecManager = new security_manager();
$client_ip = $NetInfo->get_client_ip();
// Clean up expired blocks
$SecManager->cleanup_expired_blocks();

// Check if IP is blocked
$blocked_info = $SecManager->is_ip_blocked($client_ip);

if ($blocked_info) {
    // IP is blocked, show block page
    if ($_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/blocked.php') {
        header('Location: /blocked.php');
        exit();
    }
}
if ( isset($_POST["user"]) && isset($_POST["password"]) ) {
    $results = $SecMan->pam_login($_POST["user"], $_POST["password"]);
    if ( $results == TRUE ) {
        // Successful login - regenerate session ID to prevent session fixation
        session_regenerate_id(true);
        
        define('AUTH_USER',$_POST["user"]);
        define('HOME_DIR', $SecMan->get_home_dir($_POST["user"]));
        $user_ip = $NetInfo->get_client_ip();
        $nonce = $SecMan->create_nonce($_POST['user'], $user_ip,NONCE_SALT);
        $_SESSION['nonce'] = $nonce;
        
        // Generate CSRF token for this session
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        
        // Record successful login and clear failed attempts
        $SecManager->record_successful_login($user_ip);
        
        // Redirect to index page
        header('Location: /index.php');
        exit();
    } else {
        // Failed login
        $user_ip = $NetInfo->get_client_ip();
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        $SecManager->record_failed_login($user_ip, $_POST["user"], $user_agent);
        
        // Set error message and redirect back to login
        $_SESSION['login_error'] = 'Invalid username or password.';
        header('Location: /login.php');
        exit();
    }
}elseif ( isset($_SESSION['nonce'])) {
    //Test login details before getting Nonce configured
    $nonce_check = $SecMan->check_nonce($_SESSION['nonce'],$NetInfo->get_client_ip());
    if ( $nonce_check == FALSE ) {
        unset($_SESSION['nonce']);
        if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
            if ( empty($_SERVER['HTTPS'] ) ) {
                $protocol = "http://";
                $port = "8080";
            } else {
                $protocol = "https://";
                $port = "8443";
            }
            $domain = $_SERVER['SERVER_NAME'];
            $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
            header('Location: ' . $redirect_address );
        }
    }elseif (is_array($nonce_check) ) {
        define('AUTH_USER',$nonce_check['user']);
        define('HOME_DIR',$SecMan->get_home_dir($nonce_check['user']));
        $user_ip = $NetInfo->get_client_ip();
        $nonce = $SecMan->create_nonce($nonce_check['user'], $user_ip,NONCE_SALT);
        $_SESSION['nonce'] = $nonce;
        
        // Generate CSRF token for this session if not already set
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
    } else {
        print_r($nonce_check);
        die();
    }
}else {
    if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
        if ( empty($_SERVER['HTTPS'] ) ) {
            $protocol = "http://";
            $port = "8080";
        } else {
            $protocol = "https://";
            $port = "8443";
        }
        $domain = $_SERVER['SERVER_NAME'];
        $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
        header('Location: ' . $redirect_address );
    }
}

if ( isset($_REQUEST['whp-action']) && $_REQUEST['whp-action'] == 'logout') {
    unset($_SESSION['nonce']);
    if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
        if ( empty($_SERVER['HTTPS'] ) ) {
            $protocol = "http://";
            $port = "8080";
        } else {
            $protocol = "https://";
            $port = "8443";
        }
        $domain = $_SERVER['SERVER_NAME'];
        $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
        header('Location: ' . $redirect_address );
    }
}

// Check page permissions for authenticated users
if (defined('AUTH_USER') && $_SERVER['SCRIPT_FILENAME'] == '/docker/whp/web/index.php') {
    check_page_permission();
}

// CSRF Protection for all POST requests (except login and Adminer)
if (defined('AUTH_USER') && $_SERVER['REQUEST_METHOD'] === 'POST') {
    // Skip CSRF check for login form and Adminer
    if (!isset($_POST['user']) && !isset($_POST['password']) && !is_adminer_endpoint()) {
        if (!validate_csrf_token()) {
            if (is_api_endpoint()) {
                header('HTTP/1.1 403 Forbidden');
                header('Content-Type: application/json');
                echo json_encode(['status' => 'error', 'message' => 'CSRF token validation failed']);
                exit;
            } else {
                header('HTTP/1.1 403 Forbidden');
                die('CSRF token validation failed. Please try again.');
            }
        }
    }
}