<?php
/**
 * Test WHMCS connection functionality outside of WHMCS
 */

// Include the WHMCS module
require_once 'whmcs-module/whp/whp.php';

// Simulate WHMCS logModuleCall function
function logModuleCall($module, $action, $request, $response) {
    echo "[LOG] $module::$action\n";
    echo "Request: " . print_r($request, true) . "\n";
    echo "Response: " . print_r($response, true) . "\n";
    echo "---\n";
}

// Test server configuration
$serverdata = array(
    'hostname' => 'whp01.cloud-hosting.io',
    'port' => 8443,
    'secure' => true,
    'username' => 'whp_a5ccd862515fb61cae778fe58edf926e9b0b85cab21d52a7', // API Key
    'password' => 'babb588d9ebf3610aa77552ccf5879618746f3626c7dc097a26119e92496f84b'  // API Secret
);

$params = array(
    'serverdata' => $serverdata
);

echo "=== Testing WHMCS WHP Module Connection ===\n\n";

try {
    echo "1. Testing whp_TestConnection function...\n";
    $result = whp_TestConnection($params);
    
    echo "TestConnection Result:\n";
    print_r($result);
    
    if ($result['success']) {
        echo "✅ Connection test PASSED\n";
    } else {
        echo "❌ Connection test FAILED: " . $result['message'] . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Exception in TestConnection: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n2. Testing direct API call...\n";

try {
    $response = whp_api_call($serverdata, 'GET', 'system.php?action=health');
    echo "✅ Direct API call successful\n";
    print_r($response);
} catch (Exception $e) {
    echo "❌ Direct API call failed: " . $e->getMessage() . "\n";
}

echo "\n=== Test Complete ===\n";
?>