-- ProFTPD Virtual Users Database Schema
-- This creates the tables needed for ProFTPD MySQL authentication

USE whp;

-- Create FTP users table for virtual user authentication
CREATE TABLE IF NOT EXISTS whp.ftp_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    uid INT NOT NULL,
    gid INT NOT NULL,
    homedir VARCHAR(255) NOT NULL,
    shell VARCHAR(50) DEFAULT '/bin/false',
    count INT DEFAULT 0,
    accessed DATETIME DEFAULT NULL,
    modified DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    created DATETIME DEFAULT CURRENT_TIMESTAMP,
    
    INDEX idx_username (username),
    INDEX idx_uid (uid)
);

-- Create FTP groups table for group management
CREATE TABLE IF NOT EXISTS whp.ftp_groups (
    id INT AUTO_INCREMENT PRIMARY KEY,
    groupname VARCHAR(50) UNIQUE NOT NULL,
    gid INT NOT NULL,
    members TEXT,
    
    INDEX idx_groupname (groupname),
    INDEX idx_gid (gid)
);

-- Create FTP access log table for monitoring
CREATE TABLE IF NOT EXISTS whp.ftp_access_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL,
    client_ip VARCHAR(45),
    action VARCHAR(50),
    filename VARCHAR(255),
    filesize BIGINT DEFAULT 0,
    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
    
    INDEX idx_username (username),
    INDEX idx_timestamp (timestamp),
    INDEX idx_action (action)
);

-- Create FTP quotas table for per-user quotas
CREATE TABLE IF NOT EXISTS whp.ftp_quotas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    quota_type ENUM('user', 'group', 'class', 'all') DEFAULT 'user',
    per_session ENUM('false', 'true') DEFAULT 'false',
    limit_type ENUM('soft', 'hard') DEFAULT 'soft',
    bytes_in_avail BIGINT DEFAULT 0,
    bytes_out_avail BIGINT DEFAULT 0,
    bytes_xfer_avail BIGINT DEFAULT 0,
    files_in_avail INT DEFAULT 0,
    files_out_avail INT DEFAULT 0,
    files_xfer_avail INT DEFAULT 0,
    
    INDEX idx_username (username),
    INDEX idx_quota_type (quota_type)
);

-- Insert default FTP group
INSERT IGNORE INTO whp.ftp_groups (groupname, gid, members) VALUES 
('ftpusers', 1000, '');

-- Create indexes for better performance
CREATE INDEX IF NOT EXISTS idx_ftp_users_login ON whp.ftp_users (username, password);
CREATE INDEX IF NOT EXISTS idx_ftp_access_user_time ON whp.ftp_access_log (username, timestamp); 