<?php
// pgAdmin 4 SSO Integration
// This script provides single sign-on to pgAdmin using WHP authentication

// Check if user is authenticated
if (!defined('AUTH_USER')) {
    header('Location: login.php');
    exit();
}

// Get PostgreSQL credentials
$pgUser = AUTH_USER;
$pgPassword = '';

// For root user, use the postgres superuser
if (AUTH_USER === 'root') {
    $pgUser = 'postgres';
    // Get password from .pgpass
    if (file_exists('/root/.pgpass')) {
        $pgpass_content = shell_exec('cat /root/.pgpass | head -1');
        if ($pgpass_content) {
            $pgpass_parts = explode(':', trim($pgpass_content));
            if (count($pgpass_parts) >= 5) {
                $pgPassword = $pgpass_parts[4];
            }
        }
    }
} else {
    // For regular users, we need to get their PostgreSQL password
    // This would typically be stored in the database or generated
    // For now, redirect to pgAdmin login
    header('Location: /pgadmin4/');
    exit();
}

// Create pgAdmin session
// Note: pgAdmin 4 doesn't have a built-in SSO mechanism like phpMyAdmin
// This is a placeholder for future implementation when pgAdmin supports it

// For now, redirect to pgAdmin with instructions
?>
<!DOCTYPE html>
<html>
<head>
    <title>pgAdmin Access - <?php echo htmlspecialchars(AUTH_USER); ?></title>
    <link href="bootstrap5/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 50px;
        }
        .container {
            max-width: 600px;
        }
        .card {
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .credentials {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .credential-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        .credential-value {
            font-family: monospace;
            background-color: #e9ecef;
            padding: 5px 10px;
            border-radius: 3px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">pgAdmin 4 Access</h4>
            </div>
            <div class="card-body">
                <?php if (AUTH_USER === 'root'): ?>
                <div class="alert alert-info">
                    <strong>PostgreSQL Superuser Access</strong><br>
                    Use these credentials to log into pgAdmin:
                </div>
                
                <div class="credentials">
                    <div class="credential-item">
                        <strong>Server:</strong>
                        <span class="credential-value">localhost:5432</span>
                    </div>
                    <div class="credential-item">
                        <strong>Username:</strong>
                        <span class="credential-value"><?php echo htmlspecialchars($pgUser); ?></span>
                    </div>
                    <div class="credential-item">
                        <strong>Password:</strong>
                        <span class="credential-value"><?php echo htmlspecialchars($pgPassword); ?></span>
                    </div>
                </div>
                
                <div class="alert alert-warning">
                    <strong>First Time Setup:</strong><br>
                    1. Click "Add New Server" in pgAdmin<br>
                    2. Name: <code>WHP PostgreSQL</code><br>
                    3. Connection tab: Use the credentials above<br>
                    4. Save password: Check this option for convenience
                </div>
                <?php else: ?>
                <div class="alert alert-info">
                    Please use your PostgreSQL database credentials to log into pgAdmin.
                    If you don't have PostgreSQL access, please contact your administrator.
                </div>
                <?php endif; ?>
                
                <div class="text-center mt-4">
                    <a href="/pgadmin4/" class="btn btn-primary" target="_blank">
                        <i class="fa fa-external-link"></i> Open pgAdmin 4
                    </a>
                    <a href="index.php?page=postgresql-management" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i> Back to PostgreSQL Management
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>