<?php
/**
 * Test SSO API endpoint to debug WHMCS SSO issues
 */

// Include the WHMCS module to get API key
require_once 'whmcs-module/whp/whp.php';

echo "=== Testing SSO API Endpoint ===\n\n";

// Test server configuration (replace with your actual API credentials)
$serverdata = array(
    'hostname' => 'whp01.cloud-hosting.io',
    'port' => 8443,
    'secure' => true,
    'username' => 'whp_a5ccd862515fb61cae778fe58edf926e9b0b85cab21d52a7', // API Key
    'password' => 'babb588d9ebf3610aa77552ccf5879618746f3626c7dc097a26119e92496f84b'  // API Secret
);

// Test username (replace with an actual WHP user)
$testUsername = 'testuser';

echo "1. Testing API key permissions with system health check...\n";
try {
    $healthResponse = whp_api_call($serverdata, 'GET', 'system.php?action=health');
    if ($healthResponse['status'] === 'success') {
        echo "✅ API key works - system health check passed\n";
    } else {
        echo "❌ API key issue - health check failed: " . $healthResponse['message'] . "\n";
        exit(1);
    }
} catch (Exception $e) {
    echo "❌ API connection failed: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n2. Testing SSO token generation...\n";
try {
    $apiData = array(
        'username' => $testUsername,
        'redirect_url' => '/index.php',
        'expiry_minutes' => 10,
    );
    
    $response = whp_api_call($serverdata, 'POST', 'sso.php?action=generate_token', $apiData);
    
    echo "SSO API Response:\n";
    print_r($response);
    
    if ($response['status'] === 'success') {
        echo "✅ SSO token generation successful\n";
        echo "Login URL: " . $response['data']['login_url'] . "\n";
    } else {
        echo "❌ SSO token generation failed: " . $response['message'] . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ SSO API call failed: " . $e->getMessage() . "\n";
}

echo "\n3. Testing user existence...\n";
try {
    $userResponse = whp_api_call($serverdata, 'GET', 'users.php?action=info&username=' . urlencode($testUsername));
    
    if ($userResponse['status'] === 'success') {
        echo "✅ User '$testUsername' exists\n";
        echo "User info: " . json_encode($userResponse['data'], JSON_PRETTY_PRINT) . "\n";
    } else {
        echo "❌ User '$testUsername' not found: " . $userResponse['message'] . "\n";
        echo "Note: You may need to change \$testUsername to an actual WHP user\n";
    }
    
} catch (Exception $e) {
    echo "❌ User lookup failed: " . $e->getMessage() . "\n";
}

echo "\n=== Test Complete ===\n";
?>