<?php
/**
 * Test WHMCS module for syntax errors and basic functionality
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== WHMCS Module Syntax Test ===\n\n";

// Define WHMCS constant to prevent die() in module
define('WHMCS', true);

echo "1. Testing module file syntax...\n";

// Test if the module file can be included without errors
try {
    ob_start();
    include 'whmcs-module/whp/whp.php';
    $output = ob_get_clean();
    
    if (!empty($output)) {
        echo "⚠️  Module produced output during include:\n$output\n";
    } else {
        echo "✅ Module included successfully with no output\n";
    }
    
} catch (ParseError $e) {
    echo "❌ Syntax Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
    exit(1);
} catch (Error $e) {
    echo "❌ Fatal Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
    exit(1);
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n2. Testing required functions exist...\n";

$required_functions = [
    'whp_ConfigOptions',
    'whp_TestConnection', 
    'whp_CreateAccount',
    'whp_SuspendAccount',
    'whp_UnsuspendAccount', 
    'whp_TerminateAccount',
    'whp_ChangePassword',
    'whp_ChangePackage',
    'whp_ServiceSingleSignOn',
    'whp_AdminSingleSignOn',
    'whp_ClientArea'
];

foreach ($required_functions as $function) {
    if (function_exists($function)) {
        echo "✅ $function - exists\n";
    } else {
        echo "❌ $function - missing\n";
    }
}

echo "\n3. Testing ConfigOptions function...\n";

try {
    $config = whp_ConfigOptions();
    if (is_array($config) && !empty($config)) {
        echo "✅ ConfigOptions returns valid array with " . count($config) . " options\n";
    } else {
        echo "❌ ConfigOptions returned invalid data\n";
        var_dump($config);
    }
} catch (Exception $e) {
    echo "❌ ConfigOptions error: " . $e->getMessage() . "\n";
}

echo "\n4. Testing basic module info...\n";
if (function_exists('whp_MetaData')) {
    try {
        $meta = whp_MetaData();
        echo "✅ MetaData function exists\n";
        print_r($meta);
    } catch (Exception $e) {
        echo "❌ MetaData error: " . $e->getMessage() . "\n";
    }
} else {
    echo "ℹ️  MetaData function not defined (optional)\n";
}

echo "\n=== Test Complete ===\n";

// Show any registered functions that start with 'whp_'
$all_functions = get_defined_functions()['user'];
$whp_functions = array_filter($all_functions, function($func) {
    return strpos($func, 'whp_') === 0;
});

if (!empty($whp_functions)) {
    echo "\nRegistered WHP functions:\n";
    foreach ($whp_functions as $func) {
        echo "- $func\n";
    }
}
?>