<?php
/**
 * Seed Sample Announcement Script
 * This script adds a sample announcement for testing
 */

// Check if running as root (alternative method without posix extension)
$current_user = shell_exec('whoami');
if (trim($current_user) !== 'root') {
    die("This script must be run as root\n");
}

/**
 * Read MySQL password from /root/.my.cnf
 */
function getMySQLPasswordFromConfig() {
    $config_file = '/root/.my.cnf';
    
    if (!file_exists($config_file)) {
        die("ERROR: MySQL config file not found: $config_file\n");
    }
    
    $config_content = file_get_contents($config_file);
    if ($config_content === false) {
        die("ERROR: Cannot read MySQL config file: $config_file\n");
    }
    
    // Parse the MySQL config file manually (more robust than parse_ini_string)
    $lines = explode("\n", $config_content);
    $in_client_section = false;
    $password = null;
    
    foreach ($lines as $line) {
        $line = trim($line);
        
        // Skip empty lines and comments
        if (empty($line) || $line[0] === '#') {
            continue;
        }
        
        // Check for section headers
        if (preg_match('/^\[([^\]]+)\]$/', $line, $matches)) {
            $in_client_section = ($matches[1] === 'client');
            continue;
        }
        
        // Look for password in client section
        if ($in_client_section && preg_match('/^password\s*=\s*(.*)$/', $line, $matches)) {
            $password = trim($matches[1]);
            // Remove quotes if present
            $len = strlen($password);
            if ($len >= 2 && 
                (($password[0] === '"' && $password[$len-1] === '"') || 
                 ($password[0] === "'" && $password[$len-1] === "'"))) {
                $password = substr($password, 1, -1);
            }
            break;
        }
    }
    
    if ($password === null) {
        die("ERROR: MySQL password not found in config file: $config_file\n");
    }
    
    return $password;
}

// Set the MySQL password for the announcement manager to use
$mysql_password = getMySQLPasswordFromConfig();
define('MYSQL_PASS', $mysql_password);

echo "MySQL Config Reader\n";
echo "===================\n";
echo "✓ Successfully read MySQL password from /root/.my.cnf\n\n";

// Load the announcement manager
require_once('/root/whp/web-files/libs/announcement_manager.php');

$AnnouncementMgr = new announcement_manager();

echo "Adding sample announcement...\n";

$sample_title = "Welcome to your Web Hosting Panel";
$sample_content = "Welcome to your new web hosting control panel. This panel allows you to manage your websites, databases, and other hosting features.

### Getting Started

- **Database Management**: Create and manage your MySQL databases and users
- **Domain Management**: Manage your domains and hosting settings  
- **File Manager**: Access your files directly through the web interface
- **DNS Manager**: Configure DNS records for your domains

### Important Notes

- Your account information is displayed on the dashboard
- Server load statistics help you monitor performance
- Contact your administrator if you need additional resources

*This is a sample announcement created during setup.*";

$result = $AnnouncementMgr->create_announcement($sample_title, $sample_content, 'root', 1, true);

if ($result['status'] === 'success') {
    echo "✓ Sample announcement created successfully!\n";
    echo "You can now see it on the dashboard and manage it from the Announcements Management page.\n\n";
} else {
    echo "✗ Failed to create sample announcement: " . $result['message'] . "\n";
}

echo "Done.\n";
?> 