<?php
require("/docker/whp/web/libs/security.php");
require('/docker/whp/web/configs/config.php');
require('/docker/whp/web/libs/network.php');
require('/docker/whp/web/libs/security_manager.php');
require('/docker/whp/web/libs/permission_checker.php');

// Function to check if current request is to an API endpoint
function is_api_endpoint() {
    $script_path = $_SERVER['SCRIPT_FILENAME'];
    $request_uri = $_SERVER['REQUEST_URI'];
    
    // Check if the script is in the API directory
    if (strpos($script_path, '/docker/whp/web/api/') !== false) {
        return true;
    }
    
    // Check if the request URI starts with /api/
    if (strpos($request_uri, '/api/') === 0) {
        return true;
    }
    
    return false;
}

$SecMan = new security_wrapper();
$NetInfo = new network_info();
$SecManager = new security_manager();
$client_ip = $NetInfo->get_client_ip();
// Clean up expired blocks
$SecManager->cleanup_expired_blocks();

// Check if IP is blocked
$blocked_info = $SecManager->is_ip_blocked($client_ip);

if ($blocked_info) {
    // IP is blocked, show block page
    if ($_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/blocked.php') {
        header('Location: /blocked.php');
        exit();
    }
}
if ( isset($_POST["user"]) && isset($_POST["password"]) ) {
    $results = $SecMan->pam_login($_POST["user"], $_POST["password"]);
    if ( $results == TRUE ) {
        // Successful login
        define('AUTH_USER',$_POST["user"]);
        define('HOME_DIR', $SecMan->get_home_dir($_POST["user"]));
        $user_ip = $NetInfo->get_client_ip();
        $nonce = $SecMan->create_nonce($_POST['user'], $user_ip,NONCE_SALT);
        $_SESSION['nonce'] = $nonce;
        
        // Record successful login and clear failed attempts
        $SecManager->record_successful_login($user_ip);
        
        // Redirect to index page
        header('Location: /index.php');
        exit();
    } else {
        // Failed login
        $user_ip = $NetInfo->get_client_ip();
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        $SecManager->record_failed_login($user_ip, $_POST["user"], $user_agent);
        
        // Set error message and redirect back to login
        $_SESSION['login_error'] = 'Invalid username or password.';
        header('Location: /login.php');
        exit();
    }
}elseif ( isset($_SESSION['nonce'])) {
    //Test login details before getting Nonce configured
    $nonce_check = $SecMan->check_nonce($_SESSION['nonce'],$NetInfo->get_client_ip());
    if ( $nonce_check == FALSE ) {
        unset($_SESSION['nonce']);
        if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
            if ( empty($_SERVER['HTTPS'] ) ) {
                $protocol = "http://";
                $port = "8080";
            } else {
                $protocol = "https://";
                $port = "8443";
            }
            $domain = $_SERVER['SERVER_NAME'];
            $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
            header('Location: ' . $redirect_address );
        }
    }elseif (is_array($nonce_check) ) {
        define('AUTH_USER',$nonce_check['user']);
        define('HOME_DIR',$SecMan->get_home_dir($nonce_check['user']));
        $user_ip = $NetInfo->get_client_ip();
        $nonce = $SecMan->create_nonce($nonce_check['user'], $user_ip,NONCE_SALT);
        $_SESSION['nonce'] = $nonce;
    } else {
        print_r($nonce_check);
        die();
    }
}else {
    if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
        if ( empty($_SERVER['HTTPS'] ) ) {
            $protocol = "http://";
            $port = "8080";
        } else {
            $protocol = "https://";
            $port = "8443";
        }
        $domain = $_SERVER['SERVER_NAME'];
        $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
        header('Location: ' . $redirect_address );
    }
}

if ( isset($_REQUEST['whp-action']) && $_REQUEST['whp-action'] == 'logout') {
    unset($_SESSION['nonce']);
    if ( $_SERVER['SCRIPT_FILENAME'] != '/docker/whp/web/login.php' && !is_api_endpoint()) {
        if ( empty($_SERVER['HTTPS'] ) ) {
            $protocol = "http://";
            $port = "8080";
        } else {
            $protocol = "https://";
            $port = "8443";
        }
        $domain = $_SERVER['SERVER_NAME'];
        $redirect_address = $protocol . $domain . ":" . $port . "/login.php";
        header('Location: ' . $redirect_address );
    }
}

// Check page permissions for authenticated users
if (defined('AUTH_USER') && $_SERVER['SCRIPT_FILENAME'] == '/docker/whp/web/index.php') {
    check_page_permission();
}