<?php
/**
 * Debug API permissions - check what permissions the API key has
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// API credentials (same as used in WHMCS)
$apiKey = 'whp_a5ccd862515fb61cae778fe58edf926e9b0b85cab21d52a7';
$apiSecret = 'babb588d9ebf3610aa77552ccf5879618746f3626c7dc097a26119e92496f84b';
$hostname = 'whp01.cloud-hosting.io';
$port = 8443;

echo "=== Debugging API Permissions ===\n\n";

// Test basic API connection
$url = "https://$hostname:$port/api/external/system.php?action=health";

$ch = curl_init();
curl_setopt_array($ch, array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        'X-API-Key: ' . $apiKey,
        'X-API-Secret: ' . $apiSecret,
    ),
));

echo "1. Testing basic API access...\n";
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);

if ($curlError) {
    echo "❌ cURL Error: $curlError\n";
    curl_close($ch);
    exit(1);
}

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n\n";

if ($httpCode == 200) {
    $data = json_decode($response, true);
    if ($data && $data['status'] === 'success') {
        echo "✅ Basic API access works\n\n";
    } else {
        echo "❌ API returned error: " . ($data['message'] ?? 'Unknown error') . "\n\n";
    }
} else {
    echo "❌ HTTP error code: $httpCode\n\n";
}

// Test SSO endpoint specifically
echo "2. Testing SSO endpoint access...\n";
$ssoUrl = "https://$hostname:$port/api/external/sso.php?action=generate_token";

curl_setopt($ch, CURLOPT_URL, $ssoUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(array(
    'username' => 'root', // Use root user which should exist
    'redirect_url' => '/index.php',
    'expiry_minutes' => 10
)));

$ssoResponse = curl_exec($ch);
$ssoHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$ssoCurlError = curl_error($ch);

echo "SSO HTTP Code: $ssoHttpCode\n";
echo "SSO Response: $ssoResponse\n";

if ($ssoCurlError) {
    echo "❌ SSO cURL Error: $ssoCurlError\n";
} else {
    $ssoData = json_decode($ssoResponse, true);
    if ($ssoData) {
        if (isset($ssoData['message']) && strpos($ssoData['message'], 'Insufficient permissions') !== false) {
            echo "❌ API key lacks 'sso_access' permission\n";
            echo "🔧 Solution: Enable 'sso_access' permission for this API key in WHP admin settings\n";
        } elseif ($ssoData['status'] === 'success') {
            echo "✅ SSO access works\n";
        } else {
            echo "❌ SSO error: " . ($ssoData['message'] ?? 'Unknown error') . "\n";
        }
    }
}

curl_close($ch);

echo "\n=== Debug Complete ===\n";
?>