#!/bin/bash

# Download xterm.js files for terminal functionality
XTERM_VERSION="5.3.0"
# Download to web-files directory which gets copied to /docker/whp/web/
TARGET_DIR="/root/whp/web-files/js/xterm"

echo "Downloading xterm.js v${XTERM_VERSION}..."

# Create target directory
mkdir -p "$TARGET_DIR"

# Download xterm.js files
cd "$TARGET_DIR"

# Core files
wget -q "https://unpkg.com/xterm@${XTERM_VERSION}/lib/xterm.js" -O xterm.js
wget -q "https://unpkg.com/xterm@${XTERM_VERSION}/css/xterm.css" -O xterm.css

# Addons
mkdir -p addons
wget -q "https://unpkg.com/xterm@${XTERM_VERSION}/lib/xterm-addon-fit.js" -O addons/xterm-addon-fit.js
wget -q "https://unpkg.com/xterm@${XTERM_VERSION}/lib/xterm-addon-web-links.js" -O addons/xterm-addon-web-links.js
wget -q "https://unpkg.com/xterm@${XTERM_VERSION}/lib/xterm-addon-attach.js" -O addons/xterm-addon-attach.js

echo "xterm.js downloaded successfully to $TARGET_DIR"

# Make sure files are readable
chmod 644 *.js *.css addons/*.js

# Copy to web document root if it exists
if [ -d "/docker/whp/web/" ]; then
    echo "Copying xterm.js files to web document root..."
    rsync -av /root/whp/web-files/js/xterm/ /docker/whp/web/js/xterm/
    echo "✓ xterm.js files copied to web root"
fi

echo "Done!"