-- Migration script to add pinned column to announcements table
-- Run this script on existing installations to add pinning functionality

USE whp;

-- Add pinned column if it doesn't exist
ALTER TABLE announcements ADD COLUMN IF NOT EXISTS pinned BOOLEAN DEFAULT FALSE;

-- Add index for pinned column if it doesn't exist
CREATE INDEX IF NOT EXISTS idx_pinned ON announcements (pinned);

-- Update existing announcements to have pinned = FALSE (default)
UPDATE announcements SET pinned = FALSE WHERE pinned IS NULL;

-- Verify the migration
SELECT 'Migration completed successfully' as status;
SELECT COUNT(*) as total_announcements FROM announcements;
SELECT COUNT(*) as pinned_announcements FROM announcements WHERE pinned = TRUE; 